<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ImageController extends CI_Controller {


//upload proposal
    public function uploadImage()
    {
        $token   = $this->input->post('token_foto');
        $id_user = $this->session->userdata('id');
        $id_gol  = 1;

        if (!isset($_FILES['file'])) {
            echo json_encode(['status'=>false]);
            return;
        }

        $ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
        $new_name = uniqid().'_'.time().'.'.$ext;

        $config['upload_path']   = './cdn/vendor/file_proposal/';
        $config['allowed_types'] = 'pdf';
        $config['file_name']     = $new_name;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file')) {
            echo json_encode(['status'=>false]);
            return;
        }

        $this->db->insert('foto', [
            'nama_foto' => $new_name,
            'token'     => $token,
            'id_user'   => $id_user,
            'id_gol'    => $id_gol
        ]);

        echo json_encode(['status'=>true]);
    }

    public function readFiles()
    {
        $id_user = $this->session->userdata('id');
        $id_gol  = 1;

        $files = $this->db
            ->where('id_user', $id_user)
            ->where('id_gol', $id_gol)
            ->order_by('id','DESC')
            ->get('foto')
            ->result();

        $html = '';

        if ($files) {
            foreach ($files as $f) {
                $html .= '
                <div class="col-md-4 mb-3">
                    <div class="border rounded p-2 text-center">
                        <iframe src="'.base_url('cdn/vendor/file_proposal/'.$f->nama_foto).'"
                                width="100%" height="200"></iframe>
                        <div class="mt-2">
                            <a href="'.base_url('cdn/vendor/file_proposal/'.$f->nama_foto).'"
                               target="_blank"
                               class="btn btn-sm btn-outline-primary">Lihat</a>
                            <button class="btn btn-sm btn-outline-danger"
                                    onclick="hapusFile(\''.$f->token.'\')">
                                Hapus
                            </button>
                        </div>
                    </div>
                </div>';
            }
        } else {
            $html = '<div class="col-12">
                        <div class="alert alert-warning">Belum ada dokumen</div>
                     </div>';
        }

        echo $html;
    }

    public function remove_foto()
    {
        $token = $this->input->post('token');

        $file = $this->db->get_where('foto',['token'=>$token])->row();
        if ($file) {
            @unlink('./cdn/vendor/file_proposal/'.$file->nama_foto);
            $this->db->delete('foto',['token'=>$token]);
        }
    }



// upload skripsi
public function uploadSkripsi()
{
    if (empty($_FILES['file']['name'])) {
        echo json_encode(['success'=>false,'msg'=>'File kosong']);
        return;
    }

    $config['upload_path']   = FCPATH . 'cdn/vendor/file_skripsi/';
    $config['allowed_types'] = 'pdf';
    $config['max_size']      = 5120;

    $this->load->library('upload', $config);

    if (!$this->upload->do_upload('file')) {
        echo json_encode([
            'success' => false,
            'msg' => strip_tags($this->upload->display_errors())
        ]);
        return;
    }

    $data     = $this->upload->data();
    $new_name = uniqid().'_'.time().'.'.$data['file_ext'];

    rename($data['full_path'], $config['upload_path'].$new_name);

    // simpan DB
    $this->db->insert('foto', [
        'nama_foto' => $new_name,
        'token'     => $this->input->post('token_foto'),
        'id_user'   => $this->session->userdata('id'),
        'id_gol'    => 2 // skripsi
    ]);

    echo json_encode(['success'=>true]);
}

public function remove_skripsi()
    {
        $token = $this->input->post('token');

        $file = $this->db->get_where('foto',['token'=>$token])->row();
        if ($file) {
            @unlink('./cdn/vendor/file_skripsi/'.$file->nama_foto);
            $this->db->delete('foto',['token'=>$token]);
        }
    }

public function readSkripsiFiles()
{
    $id_user = $this->session->userdata('id');
    $id_gol  = 2; // 🔥 skripsi

    $files = $this->db
        ->where('id_user', $id_user)
        ->where('id_gol', $id_gol)
        ->order_by('id','DESC')
        ->get('foto')
        ->result();

    if (!$files) {
        echo '<div class="alert alert-warning">Belum ada dokumen skripsi</div>';
        return;
    }

    foreach ($files as $f) {
        echo '
        <div class="col-md-4 mb-3">
            <div class="border rounded p-2 text-center">
                <iframe src="'.base_url('cdn/vendor/file_skripsi/'.$f->nama_foto).'"
                        width="100%" height="200"></iframe>

                <div class="mt-2">
                    <a href="'.base_url('cdn/vendor/file_skripsi/'.$f->nama_foto).'"
                       target="_blank"
                       class="btn btn-sm btn-outline-primary">Lihat</a>

                    <button class="btn btn-sm btn-outline-danger"
                        onclick="hapusFileSkripsi(\''.$f->token.'\')">
                        Hapus
                    </button>
                </div>
            </div>
        </div>';
    }
}



}
