<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class ImageController extends CI_Controller {


	function __construct(){
		parent::__construct();
		$this->load->database();
		$this->load->helper(array('url','file'));
        $this->load->model('model_select');
	}


	public function index()
	{

        $data['provinsi']=$this->model_select->provinsi();

		$this->load->view('dropzone_template', $data);
	
    }

// upload skripsi
public function uploadSkripsi()
{
    if ($_FILES['file']['name'] != '') {

		$config['upload_path']   = FCPATH . '/cdn/vendor/file_skripsi/'; 
		
        //$config['allowed_types'] = 'gif|jpeg|jpg|png|pdf|doc|docx'; 
		$config['allowed_types'] = 'pdf';
        
        $config['max_size']      = 5120;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file')) {
            $error = array('error' => $this->upload->display_errors());
            echo json_encode($error); // Kirim pesan error dalam format JSON
        } else {
            $data = $this->upload->data();
            $new_name = uniqid() . '_' . time() . '.' . pathinfo($data['file_name'], PATHINFO_EXTENSION);

            // Ganti nama file di server
            rename($data['full_path'], $config['upload_path'] . $new_name);

            // Simpan informasi file ke database (jika diperlukan)
            $file_data = array(
                'file_name' => $new_name,
                'file_path' => $config['upload_path'],
                'file_size' => $data['file_size'],
                // ... field lain yang diperlukan
            );
            // $this->db->insert('files', $file_data); // Contoh menyimpan ke database

			$token=$this->input->post('token_foto');

			$id_user	= $this->session->userdata('id');
			$id_gol		= '2';
		   		   
		    $this->db->insert('foto',array('nama_foto'=>$new_name,'token'=>$token,'id_user'=>$id_user,'id_gol'=>$id_gol));	


            echo json_encode(array('success' => true, 'file_name' => $new_name)); // Kirim respons sukses dalam format JSON
        }
    }
}

//Untuk menghapus foto
	function removeSkripsi(){

		//Ambil token foto
		$token=$this->input->post('token');

		
		$foto=$this->db->get_where('foto',array('token'=>$token));


		if($foto->num_rows()>0){
			
            $hasil      = $foto->row();
			$nama_foto  = $hasil->nama_foto;
            $file       = FCPATH . '/cdn/vendor/file_skripsi/' . $nama_foto;

			if(file_exists($file)){
				unlink($file);
			    $this->db->delete('foto',array('token'=>$token));
                $response = array('success' => true, 'message' => 'File berhasil dihapus.');
                echo json_encode($response);
			}else{
                $response = array('success' => false, 'message' => 'Gagal hapus file.');
                echo json_encode($response);
            }

		}else{
                $response = array('success' => false, 'message' => 'File tidak ditemukan.');
                echo json_encode($response);
        }

	}
// end skripsi

// upload proposal
public function uploadImage()
{
    if ($_FILES['file']['name'] != '') {

		$config['upload_path']   = FCPATH . '/cdn/vendor/file_proposal/'; 
		
        //$config['allowed_types'] = 'gif|jpeg|jpg|png|pdf|doc|docx'; 
		$config['allowed_types'] = 'pdf';
        
        $config['max_size']      = 5120;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file')) {
            $error = array('error' => $this->upload->display_errors());
            echo json_encode($error); // Kirim pesan error dalam format JSON
        } else {
            $data = $this->upload->data();
            $new_name = uniqid() . '_' . time() . '.' . pathinfo($data['file_name'], PATHINFO_EXTENSION);

            // Ganti nama file di server
            rename($data['full_path'], $config['upload_path'] . $new_name);

            // Simpan informasi file ke database (jika diperlukan)
            $file_data = array(
                'file_name' => $new_name,
                'file_path' => $config['upload_path'],
                'file_size' => $data['file_size'],
                // ... field lain yang diperlukan
            );
            // $this->db->insert('files', $file_data); // Contoh menyimpan ke database

			$token=$this->input->post('token_foto');

			$id_user	= $this->session->userdata('id');
			$id_gol		= '1';
		   		   
		    $this->db->insert('foto',array('nama_foto'=>$new_name,'token'=>$token,'id_user'=>$id_user,'id_gol'=>$id_gol));	


            echo json_encode(array('success' => true, 'file_name' => $new_name)); // Kirim respons sukses dalam format JSON
        }
    }
}



	public function uploadImage_old()
	{
        //$config['upload_path']   = FCPATH.'/upload-foto/';
		$config['upload_path']   = FCPATH . '/cdn/vendor/file_proposal/'; 
		$config['allowed_types'] = 'gif|jpeg|jpg|png|pdf|doc|docx'; 
		$config['max_size']      = 2048;



       $uploadDir = FCPATH . '/cdn/vendor/file_proposal/';
       $file = $_FILES['file'];
       $fileName = $file['name'];
       $filePath = $uploadDir . $fileName;

       // Periksa apakah file sudah ada
       if (file_exists($filePath)) {
           $response = array('success' => false, 'message' => 'File sudah ada.');
           echo json_encode($response);
           return;
       }	   


       // Lakukan unggah file
       if (move_uploaded_file($file['tmp_name'], $filePath)) {
		   
			$token=$this->input->post('token_foto');

			$id_user = $this->session->userdata('id');
		   		   
		   $this->db->insert('foto',array('nama_foto'=>$fileName,'token'=>$token,'id_user'=>$id_user));	
		   
           $response = array('success' => true, 'message' => 'File berhasil diunggah.');
           echo json_encode($response);
       } else {
           $response = array('success' => false, 'message' => 'Gagal mengunggah file.');
           echo json_encode($response);
       }


	}

//Untuk menghapus foto
	function remove_foto(){

		//Ambil token foto
		$token=$this->input->post('token');

		
		$foto=$this->db->get_where('foto',array('token'=>$token));


		if($foto->num_rows()>0){
			
            $hasil      = $foto->row();
			$nama_foto  = $hasil->nama_foto;
            $file       = FCPATH . '/cdn/vendor/file_proposal/' . $nama_foto;

			if(file_exists($file)){
				unlink($file);
			    $this->db->delete('foto',array('token'=>$token));
                $response = array('success' => true, 'message' => 'File berhasil dihapus.');
                echo json_encode($response);
			}else{
                $response = array('success' => false, 'message' => 'Gagal hapus file.');
                echo json_encode($response);
            }

		}else{
                $response = array('success' => false, 'message' => 'File tidak ditemukan.');
                echo json_encode($response);
        }

	}


//Untuk menghapus foto
	function hapus_foto(){

		//Ambil token foto
		$token=$this->input->post('token');

		
		$foto=$this->db->get_where('proposal_mahasiswa',array('id'=>$token));


		if($foto->num_rows()>0){
			
            $hasil      = $foto->row();
			$nama_foto  = $hasil->file_3A2;
            $file       = FCPATH . '/cdn/vendor/file_3A2/' . $nama_foto;

			if(file_exists($file)){
				unlink($file);
                $data['file_3A2'] = '';
                $data['status'] = '0';
			    $this->db->update('proposal_mahasiswa', $data, ['id' => $token]);
                $response = array('success' => true, 'message' => 'File berhasil dihapus.');
                echo json_encode($response);
			}else{
                $response = array('success' => false, 'message' => 'Gagal hapus file.');
                echo json_encode($response);
            }


		}else{
                $response = array('success' => false, 'message' => 'File tidak ditemukan.');
                echo json_encode($response);
        }

	}




function ambil_data(){

$modul=$this->input->post('modul');
$id=$this->input->post('id');

if($modul=="kabupaten"){
echo $this->model_select->kabupaten($id);
}
else if($modul=="kecamatan"){
echo $this->model_select->kecamatan($id);

}
else if($modul=="kelurahan"){
echo $this->model_select->kelurahan($id);
}
}



}