<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report6 extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Seminar_model');
    }

    // Halaman daftar semua seminar (opsional)
    public function index()
    {
        $data['dataMahasiswa'] = $this->Seminar_model->get_all();
        $this->load->library('pdf');
        $this->pdf->setPaper('A4','potrait');
        $this->pdf->filename = "berita_acara";
        $this->pdf->load_view('cetak/berita_acara', $data);
    }

    // Cetak berita acara seminar
    public function cetak($id = null)
    {
        $data['kasir'] = $this->session->userdata('id');

        // Ambil detail seminar
        $detail = $this->Seminar_model->details($id);

        if ($detail['error']) {
            show_error("Data seminar tidak ditemukan!");
            return;
        }

        $data['rs'] = $detail['data'];

        // Ambil nama hari dari tanggal seminar
        $hari = date('N', strtotime($data['rs']['tanggal'])); // 1=Senin ... 7=Minggu
        $array_hari = [
            1 => 'Senin',
            2 => 'Selasa',
            3 => 'Rabu',
            4 => 'Kamis',
            5 => 'Jumat',
            6 => 'Sabtu',
            7 => 'Minggu'
        ];
        $data['namahari'] = $array_hari[$hari];

        $data['waktu_cetak'] = date('Y-m-d H:i');

        // Load view cetak
        $this->load->view('cetak/berita_acara', $data);
    }

    // Cetak Tugas Akhir (skripsi)
    public function cetak_ta($id = null)
    {
        $data['kasir'] = $this->session->userdata('id');

        $detail = $this->Seminar_model->get_ta($id);
        if (!$detail) {
            show_error("Data skripsi tidak ditemukan!");
            return;
        }

        $data['rs'] = $detail;

        $hari = date('N', strtotime($data['rs']->tanggal ?? date('Y-m-d')));
        $array_hari = [
            1 => 'Senin',
            2 => 'Selasa',
            3 => 'Rabu',
            4 => 'Kamis',
            5 => 'Jumat',
            6 => 'Sabtu',
            7 => 'Minggu'
        ];
        $data['namahari'] = $array_hari[$hari];

        $data['waktu_cetak'] = date('Y-m-d H:i');

        $this->load->view('cetak/skripsi', $data);
    }

    // Cetak Hasil Etik / HK3
    public function cetak_etik($id = null)
    {
        $data['kasir'] = $this->session->userdata('id');

        $detail = $this->Seminar_model->get_etik($id);
        if (!$detail) {
            show_error("Data kegiatan tidak ditemukan!");
            return;
        }

        $data['rs'] = $detail;

        $hari = date('N', strtotime($data['rs']->tanggal ?? date('Y-m-d')));
        $array_hari = [
            1 => 'Senin',
            2 => 'Selasa',
            3 => 'Rabu',
            4 => 'Kamis',
            5 => 'Jumat',
            6 => 'Sabtu',
            7 => 'Minggu'
        ];
        $data['namahari'] = $array_hari[$hari];

        $data['waktu_cetak'] = date('Y-m-d H:i');

        $this->load->library('pdf');
        $this->pdf->setPaper('A4','potrait');
        $this->pdf->filename = "berita_acara";
        $this->pdf->load_view('cetak/etik', $data);
    }
}

/* End of file Report6.php */
/* Location: ./application/controllers/admin/Report6.php */
