<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report6 extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Seminar_model');
    }

    // Halaman daftar mahasiswa untuk preview
    public function index()
    {
        $data['dataMahasiswa'] = $this->Seminar_model->get_all();
        $this->load->library('pdf');
        $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->filename = "berita_acara";
        $this->pdf->load_view('cetak/berita_acara', $data);
    }

    // Cetak berita acara seminar
    public function cetak($id = null)
    {
        $data['kasir'] = $this->session->userdata('id');
        
        // Ambil data seminar sebagai array
        $rs = $this->Seminar_model->get_berita($id);
        if (is_object($rs)) $rs = (array) $rs;
        $data['rs'] = $rs;

        // Data tambahan jika ingin
        $data['dataMahasiswa'] = $this->Seminar_model->get_all();
        $data['waktu_cetak'] = date('Y-m-d H:i');

        $this->load->view('cetak/berita_acara', $data);
    }

    // Cetak berita acara tugas akhir
    public function cetak_ta($id = null)
    {
        $data['kasir'] = $this->session->userdata('id');
        $rs = $this->Seminar_model->get_ta($id);
        if (is_object($rs)) $rs = (array) $rs;
        $data['rs'] = $rs;
        $data['dataMahasiswa'] = $this->Seminar_model->get_all();
        $data['waktu_cetak'] = date('Y-m-d H:i');

        $this->load->view('cetak/skripsi', $data);
    }

    // Cetak kegiatan etika
    public function cetak_etik($id = null)
    {
        $data['kasir'] = $this->session->userdata('id');
        $rs = $this->Seminar_model->get_etik($id);
        if (is_object($rs)) $rs = (array) $rs;
        $data['rs'] = $rs;
        $data['dataMahasiswa'] = $this->Seminar_model->get_all();
        $data['waktu_cetak'] = date('Y-m-d H:i');

        $this->load->library('pdf');
        $this->pdf->setPaper('A4', 'portrait');
        $this->pdf->filename = "berita_acara";
        $this->pdf->load_view('cetak/etik', $data);
    }
}
