<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report6 extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Seminar_model');
        $this->load->library('pdf');
    }


public function cetak($id)
{
    $rs = $this->Seminar_model->get_berita_acara($id);

    if (empty($rs)) {
        show_error('Data tidak ditemukan');
    }

    // data umum diambil dari record pertama
    $first = $rs[0];

    $hari = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
    $namahari = $hari[ date('w', strtotime($first['tanggal'])) ];

    // hitung jumlah ttd
    $jumlah_ttd = count($rs);
    $isFinal = ($jumlah_ttd >= 3);

    $data = [
        'rs'        => $rs,
        'first'     => $first,
        'namahari'  => $namahari
    ];

    $html = $this->load->view('cetak/berita_acara_modern', $data, true);

    $this->pdf->generate(
        $html,
        'berita_acara_'.$id.'.pdf',
        $isFinal
    );
}


    public function cetak_old($seminar_id)
    {
        /* ===============================
           DATA UTAMA BERITA ACARA
           =============================== */
        $rs = $this->Seminar_model->getHeaderBeritaAcara($seminar_id);

        if (!$rs) {
            show_error('Data seminar tidak ditemukan');
        }

        // pastikan array
        $rs = (array) $rs;

        /* ===============================
           NAMA HARI
           =============================== */
        $hari = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
        $rs['namahari'] = $hari[ date('w', strtotime($rs['tanggal'])) ];

        /* ===============================
           DATA TTD DOSEN (3 RECORD)
           =============================== */
        $ttd_dosen = $this->Seminar_model->getBeritaAcara($seminar_id);

        /* ===============================
           STATUS FINAL / DRAFT
           =============================== */
        $isFinal = (count($ttd_dosen) === 3);

        /* ===============================
           DATA KE VIEW
           =============================== */
        $data = [
            'rs'        => $rs,
            'ttd_dosen' => $ttd_dosen,
            'isFinal'   => $isFinal
        ];

        /* ===============================
           RENDER HTML
           =============================== */
        $html = $this->load->view('cetak/berita_acara_modern', $data, true);

        /* ===============================
           GENERATE PDF
           =============================== */
        $this->pdf->generate(
            $html,
            'berita_acara_seminar_'.$seminar_id.'.pdf',
            $isFinal
        );
    }
}
