<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Seminar extends MY_Controller {

    function __construct(){
        parent::__construct();
        $this->load->database();
        $this->load->helper(array('url','file'));
        $this->load->model('File_model'); // Load model
    }

    public function index() {
        return $this->load->view('dosen/seminar');
    }

    public function detail($id = null) {
        if ($id) {
            return $this->load->view('dosen/seminar_detail', ['seminar_id' => $id]);
        }
        redirect(base_url('dosen/seminar'));
    }

    public function penguji($id = null) {
        if ($id) {
            return $this->load->view('dosen/seminar_penguji', ['seminar_id' => $id]);
        }
        redirect(base_url('dosen/seminar'));
    }   

    public function pembimbing($id = null) {
        if ($id) {
            return $this->load->view('dosen/seminar_pembimbing', ['seminar_id' => $id]);
        }
        redirect(base_url('dosen/seminar'));
    }

    public function pembimbing2($id = null) {
        if ($id) {
            return $this->load->view('dosen/seminar_pembimbing2', ['seminar_id' => $id]);
        }
        redirect(base_url('dosen/seminar'));
    }

    public function dosen($id, $id1) {
        if ($id) {
            $id_gol = '1';
            $data['files'] = $this->File_model->get_files($id1, $id_gol);
            $data['seminar_id'] = $id;
            return $this->load->view('dosen/seminar_dosen', $data);
        }
        redirect(base_url('dosen/seminar'));
    }

    
    /**
     * Simpan tanda tangan dosen sebagai PNG
     */
public function simpan_ttd() {
    if ($this->session->userdata('level') != 2) {
        show_error('Akses ditolak');
    }

    $image = $this->input->post('image');
    $seminar_id = $this->input->post('seminar_id');
    $dosen_id = $this->session->userdata('id');

    if (!$image || !$seminar_id) {
        echo json_encode(['status' => false, 'message' => 'Data tidak lengkap']);
        return;
    }

    // Hapus header base64
    $image = str_replace('data:image/png;base64,', '', $image);
    $image = base64_decode($image);

    $filename = 'ttd_dosen'.$dosen_id.'_'.$seminar_id.'.png';
    $path = FCPATH.'assets/ttd/';

    if (!is_dir($path)) mkdir($path, 0777, true);

    if(file_put_contents($path.$filename, $image)) {

        // Simpan/Update ke database
        $cek = $this->db->get_where('ttd_dosen', [
            'seminar_id' => $seminar_id,
            'dosen_id' => $dosen_id
        ])->row();

        $data_db = [
            'seminar_id' => $seminar_id,
            'dosen_id' => $dosen_id,
            'file_ttd' => $filename,
            'waktu_ttd' => date('Y-m-d H:i:s')
        ];

        if ($cek) {
            // Update record jika sudah ada
            $this->db->where('id', $cek->id);
            $this->db->update('ttd_dosen', $data_db);
        } else {
            // Insert baru
            $this->db->insert('ttd_dosen', $data_db);
        }

        echo json_encode(['status' => true, 'file' => $filename]);

    } else {
        echo json_encode(['status' => false, 'message' => 'Gagal menyimpan file']);
    }
}


    /**
     * Ambil URL tanda tangan dosen jika sudah ada
    */
    public function ambil_ttd($seminar_id) {
        if ($this->session->userdata('level') != 2) {
            show_error('Akses ditolak');
        }

        $dosen_id = $this->session->userdata('id');
        $filename = 'ttd_dosen'.$dosen_id.'_'.$seminar_id.'.png';
        $path = FCPATH.'assets/ttd/'.$filename;

        if(file_exists($path)) {
            echo json_encode(['tanda_tangan' => base_url('assets/ttd/'.$filename)]);
        } else {
            echo json_encode(['tanda_tangan' => null]);
        }
    }

    /**
     * Fungsi hapus file proposal (jika diperlukan)
     */
    public function hapus_file() {
        $token = $this->input->post('token');
        if(!$token) {
            echo json_encode(['status' => false]);
            return;
        }
        // Logic hapus file sesuai token di File_model
        $this->File_model->hapus_file_by_token($token);
        echo json_encode(['status' => true]);
    }
}

/* End of file Seminar.php */
