<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Hasil_kegiatan_model extends CI_Model
{

	protected $table = 'hasil_kegiatan';


public function index($post)
{
    $this->db->from('hasil_kegiatan_v');

    if (!empty($post['mahasiswa_id'])) {
        $this->db->where('mahasiswa_id', $post['mahasiswa_id']);
    }

    $data = $this->db->get()->result();

    return [
        'error' => false,
        'data'  => $data
    ];
}


	function get_etik($id){
		$sql = "SELECT * FROM hasil_kegiatan_v WHERE id = '$id' LIMIT 1";
		return $this->db->query($sql)->row();
	}	


	function get_dosen($id){
		$sql = "SELECT a.dosen_id, a.dosen2_id, a.dosen_penguji_id, a.judul, b.nim, b.nama, b.email, b.nomor_telepon
FROM proposal_mahasiswa a
LEFT JOIN mahasiswa b ON a.mahasiswa_id = b.id 
		WHERE a.mahasiswa_id = '$id' LIMIT 1";
		
		return $this->db->query($sql)->row();
	}	


	public function tambah($input)
	{
		$data = [
			'nim' => $input['xnim'],
			'nama' => $input['xnama'],
			'email' => $input['xemail'],
			'nomor_telepon' => $input['xnomor_telepon'],
			'judul' => $input['judul'],
			'instansi' => $input['instansi'],
			'dosen_id' => $input['dosen_id'],
			'dosen2_id' => $input['dosen2_id'],			
			'jenis_surat' => $input['jenis_surat'],
			'mahasiswa_id' => $this->session->userdata('id')
		];

		$validation = $this->app->validate($data);

		if ($validation === true) {
			$this->db->insert($this->table, $data);
			$hasil = [
				'error' => false,
				'message' => "data berhasil ditambah",
				'data_id' => $this->db->insert_id()
			];
		} else {
			$hasil = $validation;
		}

		return $hasil;
	}

public function hapus1($id, $data = [])
{
    if (!$id) {
        return [
            'error' => true,
            'message' => 'ID tidak ditemukan'
        ];
    }

    $this->db->where('id', $id);
    $this->db->delete('hasil_kegiatan');

    return [
        'error' => false,
        'message' => 'Data berhasil dihapus'
    ];
}


public function hapus($id, $data = [])
{
    $hasil_kegiatan = $this->db
        ->get_where($this->table, ['id' => $id])
        ->row_array();

    if (!$hasil_kegiatan) {
        return [
            'error' => true,
            'message' => 'Data tidak ditemukan'
        ];
    }

    // hapus file surat
    if (!empty($data['file'])) {
        $fileSurat = FCPATH . 'cdn/vendor/hasil_kegiatan/hasil/' . $data['file'];
        if (file_exists($fileSurat)) {
            unlink($fileSurat);
        }
    }

    // hapus file kegiatan
    if (!empty($data['file_kegiatan'])) {
        $fileKegiatan = FCPATH . 'cdn/vendor/hasil_kegiatan/kegiatan/' . $data['file_kegiatan'];
        if (file_exists($fileKegiatan)) {
            unlink($fileKegiatan);
        }
    }

    // hapus data DB
    $this->db->delete($this->table, ['id' => $id]);

    return [
        'error' => false,
        'message' => 'Data berhasil dihapus'
    ];
}


    public function agree($id)
    {
        $kondisi = ['hasil_kegiatan.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi);

        if ($cek > 00) {
            $dataUpdate = array(
                'status' => '1'
            );

            if ($this->db->update($this->table, $dataUpdate, $kondisi)) {
				$hasil = [
                    'error' => false,
                    'message' => "Permohonan Surat berhasil disetujui",
                ];
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function disagree($id)
    {
        $kondisi = ['hasil_kegiatan.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi);

        if ($cek > 00) {

            if ($this->db->update($this->table, ['status' => "0"], $kondisi)) {
                $hasil = [
                    'error' => false,
                    'message' => "Permohonan Surat batal disetujui"
                ];
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }



	public function details($id)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			hasil_kegiatan.id,
			hasil_kegiatan.tanggal,
			hasil_kegiatan.jam,
			hasil_kegiatan.judul,
			hasil_kegiatan.dosen_id         as dosen1,
			hasil_kegiatan.dosen2_id        as dosen2,
			hasil_kegiatan.file,
			hasil_kegiatan.nomer_surat,
			mahasiswa.id as mahasiswa_id,
			mahasiswa.nim as mahasiswa_nim,
			mahasiswa.nama as mahasiswa_nama,
			mahasiswa.email as mahasiswa_email
		');

		$this->db->from($this->table);
		$this->db->join('mahasiswa', 'mahasiswa.id = hasil_kegiatan.mahasiswa_id', 'left');
		$this->db->where('hasil_kegiatan.id', $id);

		$seminar = $this->db->get()->row_array();

		$hasil = [
			'error' => ($seminar) ? false : true,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar
		];



		return $hasil;
	}	


	public function edit2($input, $seminar_id)
	{

		$data = [
			'nomer_surat' => $input['nomer_surat'],
			'tanggal' => $input['tanggal']
		];


		$validation = $this->app->validate($data);

		if ($validation === true) {

			if ($input['file']) {
				$file = explode(';base64,', $input['file'])[1];
				$file_nama = date('Ymdhis') . '.pdf';
				file_put_contents(FCPATH . 'cdn/vendor/file/' . $file_nama, base64_decode($file));
				$data['file'] = $file_nama;
			}

			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}

		return $hasil;
	}		





}

/* End of file Hasil_kegiatan_model.php */
/* Location: ./application/models/Hasil_kegiatan_model.php */