<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Proposal_mahasiswa_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Email_model', 'emailm');
    }

    protected $table = "proposal_mahasiswa";



public function cari_data($keyword) {
    //$this->db->like('mahasiswa_id', $keyword);
    $query = $this->db->get('proposal_mahasiswa');
    return $query->result();
}


    public function get_files($id_user, $id_gol) {
        
        $this->db->where('mahasiswa_id = "'.$id_user.'"');
        $this->db->where('status = "'.$id_gol.'"');
        $query = $this->db->get('proposal_mahasiswa');
   
        //$query=$this->db->get_where('proposal_mahasiswa',array('mahasiswa_id'=>$id_user,'status'=>$id_gol));

        return $query->result();
    }





    public function get($input)
    {

        $kondisi = [];
        $kondisi1 = [];
        $kondisi2 = [];

        if ($input['dosen_id']) {
            $kondisi['proposal_mahasiswa.dosen_id'] = $input['dosen_id'];
            $kondisi1['proposal_mahasiswa.dosen2_id'] = $input['dosen_id'];
            $kondisi2['proposal_mahasiswa.dosen_penguji_id'] = $input['dosen_id'];
        }

        if ($input['status']) {
            $kondisi['status'] = $input['status'];
        }

        if ($input['mahasiswa_id']) {
            $kondisi['mahasiswa_id'] = $input['mahasiswa_id'];
        }

        $this->db->select("*");
        
        if ($kondisi) {
            $this->db->where($kondisi);
            $this->db->or_where($kondisi1);
            $this->db->or_where($kondisi2);
        }

        $proposal_mahasiswa = $this->db->get($this->table)->result_array();

        $hasil['error'] = false;
        $hasil['message'] = ($proposal_mahasiswa) ? "data berhasil ditemukan" : "data tidak tersedia";
        $hasil['data'] = $proposal_mahasiswa;

        foreach ($proposal_mahasiswa as $key => $item) {
            $hasil['data'][$key]['mahasiswa'] = $this->db->get_where('mahasiswa_v', ['mahasiswa_v.id' => $item['mahasiswa_id']])->row_array();
            $hasil['data'][$key]['pembimbing'] = $this->db->get_where('dosen', ['dosen.id' => $item['dosen_id']])->row_array();
            $hasil['data'][$key]['pembimbing2'] = $this->db->get_where('dosen', ['dosen.id' => $item['dosen2_id']])->row_array();
		

            if($item['dosen_penguji_id'] == 0){
                $hasil['data'][$key]['penguji'] = '';
            }else{
                $hasil['data'][$key]['penguji'] = $this->db->get_where('dosen', ['dosen.id' => $item['dosen_penguji_id']])->row_array();
            }

            
        
        }

        return $hasil;
    }

    public function create($input)
    {
        $data = [
            'mahasiswa_id' => $input['mahasiswa_id'],
            'judul' => $input['judul'],
            'ringkasan' => $input['ringkasan'],
            'dosen_id' => $input['dosen_id'],
            'dosen2_id' => $input['dosen2_id'],
            'jenis_skripsi' => $input['jenis_skripsi']            
        ];

        $validate = $this->app->validate($data);

        if ($validate === true) {
            $this->db->insert($this->table, $data);
            $data_id = $this->db->insert_id();
            $hasil = [
                'error' => false,
                'message' => "data berhasil ditambah",
                'data_id' => $data_id
            ];
        } else {
            $hasil = $validate;
        }

        return $hasil;
    }

    public function update($input, $id)
    {
        $data = [
            'mahasiswa_id' => $input['mahasiswa_id'],
            'judul' => $input['judul'],
            'ringkasan' => $input['ringkasan'],
            'dosen_id' => $input['dosen_id'],
            'dosen2_id' => $input['dosen2_id'],
            'dosen_penguji_id' => $input['dosen_penguji_id'],            
            'jenis_skripsi' => $input['jenis_skripsi']
        ];

        $kondisi = ['proposal_mahasiswa.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi)->num_rows();

        if ($cek > 0) {
            $validate = $this->app->validate($data);

            if ($validate === true) {
                $this->db->update($this->table, $data, $kondisi);
                $hasil = [
                    'error' => false,
                    'message' => "data berhasil diedit"
                ];
            } else {
                $hasil = $validate;
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function update1($input, $id)
    {
        $data = [
            'mahasiswa_id' => $input['mahasiswa_id'],
            'judul' => $input['judul'],
            'ringkasan' => $input['ringkasan'],
            'dosen_id' => $input['dosen_id'],
            'dosen2_id' => $input['dosen2_id'],            
            'jenis_skripsi' => $input['jenis_skripsi']
        ];

        $kondisi = ['proposal_mahasiswa.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi)->num_rows();

        if ($cek > 0) {
            $validate = $this->app->validate($data);

            if ($validate === true) {
                $this->db->update($this->table, $data, $kondisi);
                $hasil = [
                    'error' => false,
                    'message' => "data berhasil diedit"
                ];
            } else {
                $hasil = $validate;
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }   


	public function edit2($input, $seminar_id)
	{


			if ($input['file_3A2']) {
				$file_3A2_file = explode(';base64,', $input['file_3A2'])[1];
				$file_3A2_nama = date('Ymdhis') . '.pdf';
				file_put_contents(FCPATH . 'cdn/vendor/file_3A2/' . $file_3A2_nama, base64_decode($file_3A2_file));
				$data['file_3A2'] = $file_3A2_nama;
			}


			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}

		return $hasil;
	}	



	public function edit3($input, $seminar_id)
	{


        if ($input['dosen_penguji_id'] == ''){
                $data = [
                    'judul' => $input['proposal_mahasiswa_judul'],
                    'ringkasan' => $input['ringkasan'],
                    'dosen_id' => $input['dosen_id'],
                    'dosen2_id' => $input['dosen2_id'],
                    'jenis_skripsi' => $input['jenis_skripsi']
                ];
        }else{
                $data = [
                    'judul' => $input['proposal_mahasiswa_judul'],
                    'ringkasan' => $input['ringkasan'],
                    'dosen_id' => $input['dosen_id'],
                    'dosen2_id' => $input['dosen2_id'],
                    'dosen_penguji_id' => $input['dosen_penguji_id'],
                    'jenis_skripsi' => $input['jenis_skripsi']
                ];
        }




		$validation = $this->app->validate($data);


		if ($validation === true) {

			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}


		return $hasil;
	}	




    public function destroy($id)
    {

		// hapus folder file_proposal

		$id_user	= $this->session->userdata('id');

		$kondisi = [
			'id_user' => $id_user
		];

		$hasil_foto = $this->db->get_where('foto', ['id_user' => $id_user])->result_array();

			foreach ($hasil_foto as $key => $item) {
				if ($item['nama_foto']) {
					unlink(FCPATH . 'cdn/vendor/file_proposal/' . $item['nama_foto']);
				}
			}

		$this->db->delete("foto", ['id_user' => $id_user]);

		// end hapus folder file_proposal

        $kondisi = ['proposal_mahasiswa.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi)->num_rows();

        if ($cek > 0) {


		    $hasil_foto = $this->db->get_where('proposal_mahasiswa', ['id' => $id])->result_array();

			foreach ($hasil_foto as $key => $item) {
				if ($item['file_3A2']) {
					unlink(FCPATH . 'cdn/vendor/file_3A2/' . $item['file_3A2']);
				}
			}


            $this->db->delete($this->table, $kondisi);
            $hasil = [
                'error' => false,
                'message' => "data berhasil dihapus"
            ];
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function agree($id, $deadline)
    {
 
        $kondisi = ['proposal_mahasiswa.id' => $id];
                
        $cek = $this->db->get_where($this->table, $kondisi);

        if ($cek > 00) {
            $dataUpdate = array(
                'status' => '1',
                'deadline' => $deadline
            );

            $email = '';
            $dProposal = $this->db->get_where('proposal_mahasiswa_v', array('id' => $id))->result();
            foreach ($dProposal as $dp) {
                $email = $dp->email;
            }

                
            $this->db->where('id = "'.$id.'" AND dosen_penguji_id > 0 AND file_3A2 <> "" ');

            $db = $this->db->update('proposal_mahasiswa', $dataUpdate);

$this->db->where('id = "'.$id.'"');
$query = $this->db->get('proposal_mahasiswa')->row();

            if ($query->status == 1) {
                
                $isi_email = '
                    <p>Usulan proposal anda telah disetujui, silahkan lanjut ke tahap berikutnya.</p>
                    ';
                
                    //$this->emailm->send('Usulan Proposal Disetujui', $email, $isi_email);

                $hasil = [
                    'error' => false,
                    'message' => "proposal berhasil disetujui",
                ];


            } else {


                if (($query->dosen_penguji_id == 0) AND (is_null($query->file_3A2))) {
                    $hasil = [
                        'error' => true,
                        'message' => "dokter penguji & FILE 3A tidak ditemukan, proposal tidak berhasil disetujui",
                    ];
                } else if (is_null($query->file_3A2)) {
                    $hasil = [
                        'error' => true,
                        'message' => "FILE 3A tidak ditemukan, proposal tidak berhasil disetujui",
                    ];
                } else {
                    $hasil = [
                        'error' => true,
                        'message' => "dokter penguji tidak ditemukan, proposal tidak berhasil disetujui",
                    ];                    
                } 
             

            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function disagree($id)
    {
        $kondisi = ['proposal_mahasiswa.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi);

        if ($cek > 00) {

            $email = '';
            $dProposal = $this->db->get_where('proposal_mahasiswa_v', array('id' => $id))->result();
            foreach ($dProposal as $dp) {
                $email = $dp->email;
            }

            if ($this->db->update($this->table, ['status' => "0", 'deadline' => null], $kondisi)) {

                $isi_email = '
                    <p>Usulan proposal anda tidak disetujui, silahkan membenarkan usulan proposal anda.</p>
                    ';
                $this->emailm->send('Usulan Proposal Tidak Disetujui', $email, $isi_email);

                $hasil = [
                    'error' => false,
                    'message' => "proposal batal disetujui"
                ];
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }


	public function details($id)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			proposal_mahasiswa.judul as proposal_mahasiswa_judul,
            proposal_mahasiswa.ringkasan,
            proposal_mahasiswa.jenis_skripsi,
            proposal_mahasiswa.file_3A2,
			proposal_mahasiswa.dosen_id         as dosen1,
			proposal_mahasiswa.dosen2_id        as dosen2,
			proposal_mahasiswa.dosen_penguji_id as dosen3,
			dosen.nama as dosen_penguji,
			mahasiswa.id as mahasiswa_id,
			mahasiswa.nama as mahasiswa_nama,
			mahasiswa.email
		');

		$this->db->from($this->table);
		$this->db->join('mahasiswa', 'mahasiswa.id = proposal_mahasiswa.mahasiswa_id', 'left');
		$this->db->join('dosen', 'dosen.id = proposal_mahasiswa.dosen_penguji_id', 'left');
		$this->db->where('proposal_mahasiswa.id', $id);

		$seminar = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($seminar) ? false : true,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar
		];


		return $hasil;
	}



}

/* End of file Proposal_mahasiswa_model.php */
