<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Seminar_model extends CI_Model
{

	protected $table = "seminar";


	function get_berita($id){
		$sql = "SELECT cl.id,
			cl.proposal_mahasiswa_id,
			cl.tanggal,
			DATEDIFF(cl.tanggal, CURDATE()) AS selisih,
			cl.jam,
			cl.tempat,
			cl.file_proposal,
			cl.bukti_konsultasi,
			cl.persetujuan,
			cl.sk_tim,
			kc.judul AS proposal_mahasiswa_judul,
			kc.nama_mahasiswa,
			kc.nim,
			kc.nama_prodi,
			kc.ket, kc.ket1,
			k.status AS hasil_seminar_status, k.nilai1, k.nilai2, k.nilai3,
			k.masukan1, k.masukan2, k.masukan3, 
			do1.nama AS dosen1, do2.nama AS dosen2, do3.nama AS dosen3
				FROM seminar cl 
				LEFT JOIN hasil_seminar k on (cl.id = k.seminar_id)
                LEFT JOIN proposal_mahasiswa_v kc on (kc.id = cl.proposal_mahasiswa_id)
				LEFT JOIN dosen do1 on (kc.dosen_id = do1.id)
				LEFT JOIN dosen do2 on (kc.dosen2_id = do2.id)
				LEFT JOIN dosen do3 on (kc.dosen_penguji_id = do3.id)
				WHERE cl.id = '$id'";
		return $this->db->query($sql)->row();
	}

	function get_ta($id){
		$sql = "SELECT cl.id,
			cl.id,
			cl.file_skripsi,
			cl.bukti_konsultasi,
			cl.persetujuan,
			cl.sk_tim,
			cl.jadwal_skripsi AS tanggal,
			DATEDIFF(cl.jadwal_skripsi, CURDATE()) AS selisih,
			TIME(cl.jadwal_skripsi) AS jam,			
			kc.judul_skripsi,
			kc.nama_mahasiswa,
			kc.nim,
			kc.nama_prodi,
			IF(kc.status='1','Lulus','Tidak Lulus') AS ket,

			k.masukan1, k.masukan2, k.masukan3,
			IF((k.status = 1),'Hasil Sidang DITERIMA, tanpa Perbaikan',IF((k.status = 2),'Hasil Sidang DITERIMA, dengan Perbaikan','Hasil Sidang tidak DITERIMA, Ujian Ulang')) AS ket1,

			k.status AS hasil_seminar_status, k.nilai1, k.nilai2, k.nilai3, do1.nama AS dosen1, do2.nama AS dosen2, do3.nama AS dosen3
				FROM skripsi cl 
				LEFT JOIN hasil_skripsi k ON (cl.id = k.seminar_id)
                LEFT JOIN skripsi_v kc ON (kc.id_skripsi = cl.id)
				LEFT JOIN dosen do1 ON (kc.dosen_id = do1.id)
				LEFT JOIN dosen do2 ON (kc.dosen2_id = do2.id)
				LEFT JOIN dosen do3 ON (kc.dosen_penguji_id = do3.id)
				WHERE cl.id = '$id'";
		return $this->db->query($sql)->row();
	}

	function get_etik($id){
		$sql = "SELECT cl.*, do1.nama AS dosen1, do2.nama AS dosen2
				FROM hasil_kegiatan cl
				LEFT JOIN dosen do1 ON (cl.dosen_id = do1.id)
				LEFT JOIN dosen do2 ON (cl.dosen2_id = do2.id)
				WHERE cl.id = '$id'";
		return $this->db->query($sql)->row();
	}	

  function get_seminar($id)
  {
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			substr(proposal_mahasiswa_v.judul,1,100) as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->where('seminar.id', $id);
		
    $query = $this->db->get();
    return $query->result();
  }
  
  
	
	public function view_all(){

		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			skripsi.jadwal_skripsi as tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			skripsi.judul_skripsi as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			if(proposal_mahasiswa_v.jenis_skripsi=1,"Skripsi&nbspKonvensional",if(proposal_mahasiswa_v.jenis_skripsi=2,"Sistematik&nbspReview","Case&nbspReport")) as ket,
			hasil_seminar.nilai1,
			hasil_seminar.nilai2,
			hasil_seminar.nilai3,
			hasil_skripsi.nilai1 as nilaia,
			hasil_skripsi.nilai2 as nilaib,
			hasil_skripsi.nilai3 as nilaic,			
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->join('skripsi', 'skripsi.mahasiswa_id = proposal_mahasiswa_v.mahasiswa_id', 'left');
		$this->db->join('hasil_skripsi', 'hasil_skripsi.seminar_id = skripsi.id', 'left');
		
		
		$query = $this->db->get();
		
        return $query->result();
		
	}
	
    public function view_by_date($tgl_awal, $tgl_akhir){
        $tgl_awal = $this->db->escape($tgl_awal);
        $tgl_akhir = $this->db->escape($tgl_akhir);
		
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			skripsi.jadwal_skripsi as tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			skripsi.judul_skripsi as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			if(proposal_mahasiswa_v.jenis_skripsi=1,"Skripsi&nbspKonvensional",if(proposal_mahasiswa_v.jenis_skripsi=2,"Sistematik&nbspReview","Case&nbspReport")) as ket,
			hasil_seminar.nilai1,
			hasil_seminar.nilai2,
			hasil_seminar.nilai3,
			hasil_skripsi.nilai1 as nilaia,
			hasil_skripsi.nilai2 as nilaib,
			hasil_skripsi.nilai3 as nilaic,				
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->join('skripsi', 'skripsi.mahasiswa_id = proposal_mahasiswa_v.mahasiswa_id', 'left');
		$this->db->join('hasil_skripsi', 'hasil_skripsi.seminar_id = skripsi.id', 'left');	
		
		
        $this->db->where('DATE(skripsi.jadwal_skripsi) BETWEEN '.$tgl_awal.' AND '.$tgl_akhir); // Tambahkan where tanggal nya
		
		$query = $this->db->get();
		
    return $query->result();
	}
  
  
  
  function get_all()
  {
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			proposal_mahasiswa_v.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
    $query = $this->db->get();
    return $query->result();
  }






	public function index($input)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			seminar.file_3A1,
			seminar.file_3A2,
			substr(proposal_mahasiswa_v.judul,1,100) as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.mahasiswa_id,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,

			proposal_mahasiswa_v.dosen_id         as dosen1,
			proposal_mahasiswa_v.dosen2_id        as dosen2,
			proposal_mahasiswa_v.dosen_penguji_id as dosen3,

			proposal_mahasiswa_v.nama_pembimbing as nama_pembimbing,
			proposal_mahasiswa_v.nama_pembimbing2 as nama_pembimbing2,
			proposal_mahasiswa_v.nama_penguji as nama_penguji,

			
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');


        $kondisi = [];
        $kondisi1 = [];
		$kondisi2 = [];

		if ($input['mahasiswa_id']) {
			$this->db->where('proposal_mahasiswa_v.mahasiswa_id', $input['mahasiswa_id']);
		}

		if ($input['dosen_id']) {
			$this->db->where('proposal_mahasiswa_v.dosen_id', $input['dosen_id']);
			$this->db->or_where('proposal_mahasiswa_v.dosen2_id', $input['dosen_id']);
			$this->db->or_where('proposal_mahasiswa_v.dosen_penguji_id', $input['dosen_id']);
		}		


		$seminar = $this->db->get()->result_array();

		$hasil = [
			'error' => false,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar,
		];

		return $hasil;
	}

	public function create($input)
	{
		$data = [
			'proposal_mahasiswa_id' => $input['proposal_mahasiswa_id'],
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat']
		];

		$validation = $this->app->validate($data);

		if ($validation === true) {
			$file_nama = date('Ymdhis') . '.pdf';

			$this->db->insert($this->table, $data);
			$data_id = $this->db->insert_id();
			$this->db->insert("hasil_seminar", [
				'seminar_id' => $data_id,
				'berita_acara' => "",
				'masukan1' => "",
				'masukan2' => "",
				'masukan3' => "",
				'status' => '0'
			]);

			$hasil = [
				'error' => false,
				'message' => "data berhasil ditambahkan",
				'data_id' => $data_id
			];
		} else {
			$hasil = $validation;
		}

		return $hasil;
	}


	public function edit2($input, $seminar_id)
	{

		$data = [
			'dosen_penguji_id' => $input['dosen3'],
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat']
		];


		$validation = $this->app->validate($data);

		if ($validation === true) {

			if ($input['file_3A2']) {
				$file_3A2_file = explode(';base64,', $input['file_3A2'])[1];
				$file_3A2_nama = date('Ymdhis') . '.pdf';
				file_put_contents(FCPATH . 'cdn/vendor/file_3A2/' . $file_3A2_nama, base64_decode($file_3A2_file));
				$data['file_3A2'] = $file_3A2_nama;
			}


			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}

		return $hasil;
	}	

	public function edit3($input, $seminar_id)
	{

		$data = [
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat']
		];


		$validation = $this->app->validate($data);


		if ($validation === true) {

			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}


		return $hasil;
	}	

	public function create1($input)
	{
		$data = [
			'proposal_mahasiswa_id' => $input['proposal_mahasiswa_id'],
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat'],
			'file_3A2' => $input['file_3A2']
		];

		$validation = $this->app->validate($data);

		if ($validation === true) {
			$file_nama = date('Ymdhis') . '.pdf';

			// upload base64 file_proposal

			
			$file_3A2_file = explode(';base64,', $data['file_3A2'])[1];
			file_put_contents(FCPATH . 'cdn/vendor/file_3A2/' . $file_nama, base64_decode($file_3A2_file));
			$data['file_3A2'] = $file_nama;
			


			$this->db->insert($this->table, $data);
			$data_id = $this->db->insert_id();
			$this->db->insert("hasil_seminar", [
				'seminar_id' => $data_id,
				'berita_acara' => "",
				'masukan' => "",
				'status' => '3'
			]);

			$hasil = [
				'error' => false,
				'message' => "data berhasil ditambahkan",
				'data_id' => $data_id
			];
		} else {
			$hasil = $validation;
		}

		return $hasil;
	}

	public function details($id)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,

			seminar.file_proposal,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			seminar.file_3A1,
			seminar.file_3A2,			

			proposal_mahasiswa.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa.dosen_id         as dosen1,
			proposal_mahasiswa.dosen2_id        as dosen2,
			proposal_mahasiswa.dosen_penguji_id as dosen3,
			dosen.nama as dosen_penguji,
			mahasiswa.id as mahasiswa_id,
			mahasiswa.nama as mahasiswa_nama,
			mahasiswa.email
		');

		$this->db->from($this->table);
		$this->db->join('proposal_mahasiswa', 'proposal_mahasiswa.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->join('mahasiswa', 'mahasiswa.id = proposal_mahasiswa.mahasiswa_id', 'left');
		$this->db->join('dosen', 'dosen.id = proposal_mahasiswa.dosen_penguji_id', 'left');
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->where('seminar.id', $id);

		$seminar = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($seminar) ? false : true,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar
		];

		if ($hasil['data']) {
			$hasil['data']['hasil'] = $this->db->get_where('hasil_seminar', ['seminar_id' => $hasil['data']['id']])->row_array();
		}

		return $hasil;
	}

	public function destroy($id)
	{

		$kondisi = [
			'id' => $id
		];

		$seminar = $this->db->get_where($this->table, $kondisi)->row_array();

		if ($seminar) {
			$hasil_seminar = $this->db->get_where('hasil_seminar', ['seminar_id' => $id])->result_array();
			foreach ($hasil_seminar as $key => $item) {
				if ($item['berita_acara']) {
					unlink(FCPATH . 'cdn/vendor/berita_acara/' . $item['berita_acara']);
				}
				if ($item['masukan']) {
					unlink(FCPATH . 'cdn/vendor/masukan/' . $item['masukan']);
				}
			}
			unlink(FCPATH . 'cdn/vendor/file_proposal/' . $seminar['file_proposal']);
			unlink(FCPATH . 'cdn/vendor/sk_tim/' . $seminar['sk_tim']);
			
			$this->db->delete("hasil_seminar", ['seminar_id' => $id]);


			$this->db->delete($this->table, $kondisi);
			$hasil = [
				'error' => false,
				'message' => "data berhasil dihapus"
			];
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}

		return $hasil;
	}
}

/* End of file Seminar_model.php */
/* Location: ./application/models/Seminar_model.php */