<?php $this->app->extend('template/admin') ?>

<?php $this->app->setVar('title', "Hasil Kegiatan") ?>

<?php $this->app->section() ?>
<div class="card">
    <div class="card-header">
        <div class="row">
            <div class="col-md">
                <div class="card-title">Data Hasil Kegiatan</div>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table width='1000px' id="data-hasil-kegiatan">    
                <thead>
                    <tr>

                        <th>No</th>
                        <th>NIM</th>
                        <th>Nama</th>
                        <th width='400px'>Judul</th>
                        <th>Nomer Surat</th>
                        <th>Perihal</th>
                        <th>Cetak Surat</th>
                        <th>Word</th>
                        <th>PDF</th>
                        <th>Status</th>                    
                        

                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="hapus">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="hapus">
                <div class="modal-header">
                    <div class="modal-title">Hapus Hasil Kegiatan</div>
                </div>
                <div class="modal-body">
                    <input type="hidden" class="id">
                    <input type="hidden" class="file">
                    <input type="hidden" class="file_kegiatan">
                    <p>Anda yakin ingin menghapus ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="setujui">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="setujui">
                <div class="modal-header">
                    <div class="modal-title">Status Surat</div>
                </div>
                <div class="modal-body">
                    <input type="hidden" class="id">
                    <input type="hidden" class="status">
                    <p>Anda yakin <span class="status">mengetujui / batal menyetujui</span> Permohonan Surat <strong class="nomer_surat">Judul Proposal</strong> ?</p>
                    <div id="wadah_jadwal"></div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary btn-konfirmasi">Konfirmasi</button>
                </div>
            </form>
        </div>
    </div>
</div>



<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>cdn/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<script src="<?= base_url() ?>cdn/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>cdn/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function() {

        call('api/proposal_mahasiswa').done(function(res) {
            proposal_mahasiswa = `<option value="">- Pilih Proposal -</option>`;
            if (res.data) {
                res.data.forEach(obj => {
                    if (obj.status == '1') {
                        proposal_mahasiswa += `<option value="` + obj.id + `">` + obj.judul + `</option>`;
                    }
                })
            }
            $('[name=proposal_mahasiswa_id]').html(proposal_mahasiswa);
        })

        $(document).on('change', 'form#tambah [name=pilih-file]', function() {
            read('[name=pilih-file]', function(data) {
                $('[name=file]').val(data.result);
            })
        });

        function show() {
            $('#data-hasil-kegiatan').DataTable().destroy();
            $('#data-hasil-kegiatan').DataTable({
                "deferRender": true,
                "ajax": {
                    "url": base_url + '/api/hasil_kegiatan',
                    "method": "POST",
                    "dataSrc": "data"
                },
                "columns": [{
                        data: null,
                        render: function(data, type, row, meta) {
                            return meta.row + meta.settings._iDisplayStart + 1;
                        }
                    },
                    {
                        data: "nim"
                    },
                    {
                        data: "nama_mahasiswa"
                    },
                    {
                        data: "judul"
                    },
                    {
                        data: "nomer_surat"
                    },
                    {
                        data: "hal"
                    },
                    {
                        data: null,
                        render: function(data) 
                        {
                            return '<a href="' + base_url + 'cdn/vendor/file/' + data.file + '" target="_blank">' + data.file + '</a>';
                        }
                    },
                    {
                        data: null,
                        render: function(data) {
                            return `
                            <a href="` + base_url + `admin/cetaketik/cetak/` + data.id + `" class="btn btn-sm btn-success" target="_blank">
                                <i class="fa fa-print"></i>
                            </a>`;
                        }
                    },
                    {
                        data: null,
                        render: function(data) {
                            return `
                            <a href="` + base_url + `admin/hasilkegiatan/detail/` + data.id + `" class="btn btn-sm btn-success">
                                <i class="fa fa-search"></i>
                            </a>`;
                        }
                    },
                    {
                        data: null,
                        render: function(data) {
                            if (data.status == '1') {
                                status = '\
                            <button class="btn btn-sm btn-setuju btn-success" type="button" data-id="' + data.id + '" data-nomer_surat="' + data.nomer_surat + '" data-status="' + data.status + '" data-toggle="modal" data-target="#setujui">\
                                <i class="fa fa-check"></i>\
                            </button>\
                            ';
                            } else {
                                status = '\
                            <button class="btn btn-sm btn-setuju btn-danger" type="button" data-id="' + data.id + '" data-nomer_surat="' + data.nomer_surat + '" data-status="' + data.status + '" data-toggle="modal" data-target="#setujui">\
                                <i class="fa fa-times"></i>\
                            </button>\
                            ';
                            }
                            return '\
                            <div class="text-center">' + status + '</div>\
                            ';
                        }
                    }
                ],
                "language": {
                    "zeroRecords": "data tidak tersedia"
                }
            });
        }

        show();

        $(document).on('submit', 'form#tambah', function(e) {
            e.preventDefault()
            call('api/hasil_kegiatan/tambah', $(this).serialize()).done(function(res) {
                if (res.error) {
                    notif(res.message, 'error', true);
                } else {
                    $('form#tambah [name]').val('');
                    $('div#tambah').modal('hide');
                    notif(res.message, 'success');
                    show();
                }
            })
        });



        $(document).on('click', 'button.btn-setuju', function() {
            $('form#setujui .id').val($(this).data('id'));
            $('form#setujui input.status').val($(this).data('status'));
            $('form#setujui span.status').html(($(this).data('status') == '1') ? 'batal menyetujui Surat Permohonan akan direset untuk ' : 'menyetujui');
            $('form#setujui .nomer_surat').html($(this).data('nomer_surat'));
            if ($(this).data('status') == 1) {
                $("#wadah_jadwal").html('')
            } else {
                $("#wadah_jadwal").html('')
            }
        })

 
        $(document).on('submit', 'form#setujui', function(e) {
            e.preventDefault();
            $(".btn-konfirmasi").attr('disabled', true).html('Loading...')
            if ($('form#setujui .status').val() != 1) {
                action()
            } else {
                action()
            }

            function action() {
                const id = $('form#setujui .id').val();
                call('api/hasil_kegiatan/' + (($('form#setujui .status').val() == '1') ? 'disagree' : 'agree') + '/' + id, $('form#setujui').serialize()).done(function(req) {
                    if (req.error == true) {
                        notif(req.message, 'error', true);
                        $(".btn-konfirmasi").attr('disabled', false).html('Konfirmasi')
                    } else {
                        notif(req.message, 'success');
                        $('div#setujui').modal('hide');
                        show();
                        $(".btn-konfirmasi").attr('disabled', false).html('Konfirmasi')
                    }
                })
            }
        })  


        $(document).on('click', 'button.btn-hapus', function() {
            $('form#hapus .id').val($(this).data('id'));
            $('form#hapus .file').val($(this).data('file'));
            $('form#hapus .file_kegiatan').val($(this).data('file_kegiatan'));
        });

        $(document).on('submit', 'form#hapus', function(e) {
            e.preventDefault()
            const id = $('form#hapus .id').val();
            const file = $('form#hapus .file').val();
            const file_kegiatan = $('form#hapus .file_kegiatan').val();
            $.ajax({
                url: base_url + 'api/hasil_kegiatan/hapus/' + id,
                type: 'post',
                data: {
                    file: file,
                    file_kegiatan: file_kegiatan
                },
                success: function(res) {
                    $('div#hapus').modal('hide');
                    notif(res.message, 'success');
                    show();
                }
            })
        });

    })
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>