<?php $this->app->extend('template/admin') ?>

<?php $this->app->setVar('title', 'Seminar') ?>

<?php
 $url_cetak = base_url('admin/report2');
?> 

<?php $this->app->section() ?>
<div class="card">
	<form id="edit">
		<div class="card-header">
			<div class="card-title">Detail Seminar</div>
		</div>
		<div class="card-body">
			<div class="table-responsive">
				<table class="table table-hover">

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Nomer Surat</label>
                                <input type="text" name="nomer_surat" placeholder="Masukkan Nomer Surat" class="form-control">
                            </div>
                        </div>
                    </div>                    


                    <tr>
						<td>NIM</td>
						<th class="mahasiswa_nim">-</th>
					</tr>                
                    <tr>
						<td>Nama Mahasiswa</td>
						<th class="mahasiswa_nama">-</th>
					</tr>
                    <tr>
						<td>Email</td>
						<th class="mahasiswa_email">-</th>
					</tr>                

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal</label>
                                <input type="date" name="tanggal" class="form-control">
                            </div>
                        </div>
                    </div>

					
					<tr>
						<td>Form 3A - Sebelum mendapatkan Penguji</td>
						<th class="file_a"></th>
						<th class="file"></th>
					</tr>


				
				</table>

				<input type="hidden" name="file">
	
		
			</div>
		</div>
		<div class="card-footer text-right">
			<a href="<?= base_url() ?>admin/hasilkegiatan" class="btn btn-default">Kembali</a>
			<button type="submit" class="btn btn-primary btn-act">Simpan</button>
		</div>
	</form>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script>
	var seminar_id = '<?= $seminar_id ?>'

	$(document).ready(function() {

		function show() {
			call('api/hasil_kegiatan/details/' + seminar_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'admin/hasilkegiatan';
					})
				} else {

					$('.mahasiswa_nim').html(res.data.mahasiswa_nim);
                    $('.mahasiswa_nama').html(res.data.mahasiswa_nama);
                    $('.mahasiswa_email').html(res.data.mahasiswa_email);
                                      

					$('.tanggal_jam').html(res.data.tanggal);
		

					$('.file_a').html(`<a href="` + base_url + `cdn/vendor/file/` + res.data.file + `" target="_blank">` + res.data.file + `</a>`);
					$('.file').html(('') ? `<a href="` + base_url + `cdn/vendor/file/` + '' + `">` + '' + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-file">');
							
					$('[name=tanggal]').val(res.data.tanggal);
					$('[name=nomer_surat]').val(res.data.nomer_surat);

							
		
				}
			})
		}

		show()


        call('api/dosen').done(function(req) {
            dosen = '<option value="">- Pilih Dosen -</option>';
            if (req.data) {
                $.each(req.data, function(index, obj) {
                    dosen += '<option value="' + obj.id + '">' + obj.nama + '</option>';
                })
            }
            $('[name=dosen_id]').html(dosen);
            $('[name=dosen2_id]').html(dosen);
        })    


		$(document).on('change', '[name=pilih-file]', function() {
			read('[name=pilih-file]', function(data) {
				$('[name=file]').val(data.result);
			})
		})


		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			call('api/hasil_kegiatan/edit2/' + seminar_id, $(this).serialize()).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Selesai')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Selesai')
				}
			})
		})

	})
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>