<?php $this->app->extend('template/admin') ?>
<?php $this->app->setVar('title', "Proposal") ?>

<?php $this->app->section() ?>
<div class="card">
    <div class="card-body">
        <div class="card-title">Cari Mahasiswa : </div>
        <form id="form_cari" action="<?= base_url('hasil-pencarian-mahasiswa'); ?>" method="POST">
            <input type="hidden" name="level" value="Admin">
            <select class="select2" name="id" required id="wadah_select2"></select>
            <button class="btn btn-primary mt-3" type="submit">
                Lihat Selengkapnya <i class="fa fa-chevron-right"></i>
            </button>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <div class="row">
            <div class="col">
                <div class="card-title">Data Proposal</div>
            </div>
            <div class="col text-right">
                <button class="btn btn-primary" type="button" data-toggle="modal" data-target="#tambah">
                    <i class="fa fa-plus"></i> Tambah
                </button>
            </div>
        </div>
        <div class="card-tools mt-2">
            <span class="badge badge-success"><i class="fa fa-check"></i> Disetujui</span>
            <span class="badge badge-danger ml-3"><i class="fa fa-times"></i> Belum/Tidak Disetujui</span>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table id="data-proposal" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>NIM</th>
                        <th>Mahasiswa</th>
                        <th>Judul</th>
                        <th>Dosen Pembimbing / Penguji</th>
                        <th>File 3A2</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>

<!-- ================= MODAL TAMBAH ================= -->
<div class="modal fade" id="tambah">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="tambahForm">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Proposal</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Mahasiswa</label>
                        <select name="mahasiswa_id" class="form-control" required></select>
                    </div>
                    <div class="form-group">
                        <label>Judul</label>
                        <input type="text" name="judul" class="form-control" placeholder="Masukkan Judul" required>
                    </div>
                    <div class="form-group">
                        <label>Dosen Pembimbing 1</label>
                        <select name="dosen_id" class="form-control"></select>
                    </div>
                    <div class="form-group">
                        <label>Dosen Pembimbing 2</label>
                        <select name="dosen2_id" class="form-control"></select>
                    </div>
                    <div class="form-group">
                        <label>Dosen Penguji</label>
                        <select name="dosen_penguji_id" class="form-control"></select>
                    </div>
                    <div class="form-group">
                        <label>Ringkasan</label>
                        <textarea name="ringkasan" class="form-control" rows="4"></textarea>
                    </div>
                    <div class="form-group">
                        <label>Jenis Skripsi</label>
                        <select name="jenis_skripsi" class="form-control" required>
                            <option value="">- Pilih Jenis Skripsi -</option>
                            <option value="1">Skripsi Konvensional</option>
                            <option value="2">Systematic Review</option>
                            <option value="3">Case Report</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- ================= MODAL EDIT ================= -->
<div class="modal fade" id="edit">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="editForm">
                <input type="hidden" name="id">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Proposal</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Mahasiswa</label>
                        <select name="mahasiswa_id" class="form-control" required></select>
                    </div>
                    <div class="form-group">
                        <label>Judul</label>
                        <input type="text" name="judul" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>Dosen Pembimbing 1</label>
                        <select name="dosen_id" class="form-control"></select>
                    </div>
                    <div class="form-group">
                        <label>Dosen Pembimbing 2</label>
                        <select name="dosen2_id" class="form-control"></select>
                    </div>
                    <div class="form-group">
                        <label>Dosen Penguji</label>
                        <select name="dosen_penguji_id" class="form-control"></select>
                    </div>
                    <div class="form-group">
                        <label>Ringkasan</label>
                        <textarea name="ringkasan" class="form-control" rows="4"></textarea>
                    </div>
                    <div class="form-group">
                        <label>Jenis Skripsi</label>
                        <select name="jenis_skripsi" class="form-control" required>
                            <option value="">- Pilih Jenis Skripsi -</option>
                            <option value="1">Skripsi Konvensional</option>
                            <option value="2">Systematic Review</option>
                            <option value="3">Case Report</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- ================= MODAL HAPUS ================= -->
<div class="modal fade" id="hapus">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="hapusForm">
                <input type="hidden" name="id">
                <div class="modal-header">
                    <h5 class="modal-title">Hapus Proposal</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <p>Anda yakin menghapus proposal <strong class="judul"></strong> ?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<link rel="stylesheet" href="<?= base_url() ?>cdn/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<script src="<?= base_url() ?>cdn/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>cdn/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>

<script>
var table;
$(document).ready(function(){

    // ============== DataTables =================
    table = $('#data-proposal').DataTable({
        "processing": true,
        "serverSide": false,
        "ajax": {
            "url": "<?= base_url('api/proposal_mahasiswa') ?>",
            "type": "POST",
            "dataSrc": "data"
        },
        "columns": [
            { "data": null, "render": function(data, type, row, meta){ return meta.row+1; } },
            { "data": "mahasiswa.nim" },
            { "data": "mahasiswa.nama" },
            { "data": "judul" },
            { "data": null, "render": function(data){
                return '1. '+data.pembimbing.nama+'<br>2. '+data.pembimbing2.nama+'<br>3. '+(data.penguji?data.penguji.nama:'-');
            }},
            { "data": "file_3A2", "render": function(data){
                return (data) ? '<a href="<?= base_url() ?>cdn/vendor/file_3A2/'+data+'" target="_blank">'+data+'</a>' : '';
            }},
            { "data": "status", "render": function(data){
                return (data==1)?'<span class="text-success">Disetujui</span>':'<span class="text-danger">Belum</span>';
            }},
            { "data": null, "render": function(data){
                return `
                    <button class="btn btn-sm btn-primary btn-edit" data-id="${data.id}">Edit</button>
                    <button class="btn btn-sm btn-danger btn-hapus" data-id="${data.id}" data-judul="${data.judul}">Hapus</button>
                `;
            }}
        ]
    });

    // ================= Load Select Mahasiswa & Dosen =================
    function loadSelect() {
        $.get(base_url+'getAllData/mahasiswa', function(res){
            let html = '<option value="">- Pilih Mahasiswa -</option>';
            res.forEach(item => html += `<option value="${item.id}">(${item.nim}) ${item.nama}</option>`);
            $('[name=mahasiswa_id]').html(html);
        });
        $.get(base_url+'api/dosen', function(res){
            let html = '<option value="">- Pilih Dosen -</option>';
            res.forEach(item => html += `<option value="${item.id}">${item.nama}</option>`);
            $('[name=dosen_id],[name=dosen2_id],[name=dosen_penguji_id]').html(html);
        });
    }
    loadSelect();

    // ================= Tambah =================
    $('#tambahForm').on('submit', function(e){
        e.preventDefault();
        $.post(base_url+'api/proposal_mahasiswa/create', $(this).serialize(), function(res){
            if(!res.error){
                $('#tambah').modal('hide');
                $('#tambahForm')[0].reset();
                table.ajax.reload(null, false);
                alert(res.message);
            } else { alert(res.message); }
        }, 'json');
    });

    // ================= Edit =================
    $('#data-proposal').on('click','.btn-edit', function(){
        var id = $(this).data('id');
        $.post(base_url+'api/proposal_mahasiswa/details/'+id, function(res){
            if(!res.error){
                $('#edit [name=id]').val(id);
                $('#edit [name=mahasiswa_id]').val(res.data.mahasiswa_id);
                $('#edit [name=judul]').val(res.data.proposal_mahasiswa_judul);
                $('#edit [name=dosen_id]').val(res.data.dosen1);
                $('#edit [name=dosen2_id]').val(res.data.dosen2);
                $('#edit [name=dosen_penguji_id]').val(res.data.dosen3);
                $('#edit [name=ringkasan]').val(res.data.ringkasan);
                $('#edit [name=jenis_skripsi]').val(res.data.jenis_skripsi);
                $('#edit').modal('show');
            } else { alert(res.message); }
        }, 'json');
    });

    $('#editForm').on('submit', function(e){
        e.preventDefault();
        var id = $('#edit [name=id]').val();
        $.post(base_url+'api/proposal_mahasiswa/update1/'+id, $(this).serialize(), function(res){
            if(!res.error){
                $('#edit').modal('hide');
                table.ajax.reload(null, false);
                alert(res.message);
            } else { alert(res.message); }
        }, 'json');
    });


    

// ================= Hapus =================
$('#data-proposal').on('click','.btn-hapus', function(){
    let id = $(this).data('id');
    let judul = $(this).data('judul');
    $('#hapusForm [name=id]').val(id);
    $('#hapusForm .judul').text(judul);
    $('#hapus').modal('show');
});

$('#hapusForm').on('submit', function(e){
    e.preventDefault();
    var id = $('#hapusForm [name=id]').val();

    $.ajax({
        url: base_url+'api/proposal_mahasiswa/destroy/'+id,
        type: 'POST',
        dataType: 'json',
        success: function(res){
            if(!res.error){
                $('#hapus').modal('hide'); // otomatis close
                $('#hapusForm')[0].reset();
                table.ajax.reload(null, false); // reload datatable
                notif(res.message, 'success', true); // toast sukses
            } else {
                notif(res.message, 'error', true);
            }
        },
        error: function(xhr){
            notif('Terjadi kesalahan server!', 'error', true);
            console.error(xhr.responseText);
        }
    });
});


});
</script>
<?php $this->app->endSection('script') ?>
<?php $this->app->init() ?>
