<?php $this->app->extend('template/admin') ?>

<?php $this->app->setVar('title', 'Revisi') ?>

<?php $this->app->section() ?>
<div class="card">
	<div class="card-header">
		<div class="card-title">Detail Revisi</div>
	</div>
	<form id="edit">
		<div class="card-body">
			<input type="hidden" name="persetujuan">
			<input type="hidden" name="sk_tim">
			<input type="hidden" name="berita_acara">
			<input type="hidden" name="masukan">
			<div class="table-responsive">
				<table class="table table-hover">
					<tr>
						<td>Proposal yang di Revisi</td>
						<th class="proposal_mahasiswa_judul">-</th>
					</tr>
		
					<tr>
						<td>Form 8A (Revisi Proposal)</td>
						<th class="bukti">-</th>
					</tr>



					<div class="row mb-3">
                <div class="col-md-4">
        
                    <div class="form-group">
                        <label>Nilai Dosen Pembimbing 1:</label>
                        <input type="text" name="nilai1" class="form-control" >
                    </div>
                    <div class="form-group">
                        <label>Masukan:</label>
                        <textarea name="masukan1" rows="8" class="form-control"></textarea>
                    </div>
                </div>
                <div class="col-md-4">
                  
                    <div class="form-group">
                        <label>Nilai Dosen Pembimbing 2:</label>
                        <input type="text" name="nilai2" class="form-control" >
                    </div>
                    <div class="form-group">
                        <label>Masukan:</label>
                        <textarea name="masukan2" rows="8" class="form-control"></textarea>
                    </div>
                </div>
                <div class="col-md-4">
                  
                    <div class="form-group">
                        <label>Nilai Dosen Pembimbing 3:</label>
                        <input type="text" name="nilai3" class="form-control" >
                    </div>
                    <div class="form-group">
                        <label>Masukan:</label>
                        <textarea name="masukan3" rows="8" class="form-control"></textarea>
                    </div>
                </div>
            </div>



					<tr>
						<td>Status</td>
						<th class="status">
							<select name="status" class="form-control">
                            <option value="1">DITERIMA, tanpa Perbaikan</option>
								<option value="2">DITERIMA, dengan Perbaikan tanpa Ujian Proposal Ulang</option>
								<option value="3">DITOLAK, Melakukan Ujian Ulang tanpa Mengganti Judul</option>
								<option value="4">DITOLAK, Melakukan Ujian Ulang dengan Mengganti Judul</option>
							</select>
						</th>
					</tr>

					



				</table>
			</div>
		</div>
		<input type="hidden" name="email">
		<input type="hidden" name="def_status">

		<div class="card-footer text-right">
			<a href="<?= base_url() ?>admin/revisi" class="btn btn-default">Kembali</a>
			<button type="submit" class="btn btn-primary btn-act">Simpan</button>
		</div>
	</form>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script>
	var penelitian_id = '<?= $penelitian_id ?>';
	$(document).ready(function() {

		function show() {
			call('api/revisi/details/' + penelitian_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'admin/revisi';
					});
				} else {
 
                    $('.proposal_mahasiswa_judul').html(res.data.proposal.judul);
					$('.bukti').html('<a href="' + base_url + 'cdn/vendor/revisi/' + res.data.bukti + '">' + res.data.bukti + '</a>');
				
					$('[name=status]').val(res.data.hasil.status);
					$('[name=email]').val(res.data.proposal.email);
					$('[name=def_status]').val(res.data.hasil.status);

					$('[name=masukan1]').val(res.data.hasil.masukan1);
					$('[name=masukan2]').val(res.data.hasil.masukan2);
					$('[name=masukan3]').val(res.data.hasil.masukan3);

					$('[name=nilai1]').val(res.data.hasil.nilai1);
					$('[name=nilai2]').val(res.data.hasil.nilai2);
					$('[name=nilai3]').val(res.data.hasil.nilai3);					



				}
			})
		}

		show();

		$(document).on('change', '[name=pilih-sk_tim]', function() {
			read('[name=pilih-sk_tim]', function(data) {
				$('[name=sk_tim]').val(data.result);
			})
		})

		$(document).on('change', '[name=pilih-berita_acara]', function() {
			read('[name=pilih-berita_acara]', function(data) {
				$('[name=berita_acara]').val(data.result);
			})
		})

		$(document).on('change', '[name=pilih-masukan]', function() {
			read('[name=pilih-masukan]', function(data) {
				$('[name=masukan]').val(data.result);
			})
		})

		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			const data = {
				status: $('[name=status]').val(),
				tipe: 'admin',
				berita_acara: $('[name=berita_acara]').val(),
				masukan: $('[name=masukan]').val(),
				sk_tim: $('[name=sk_tim]').val(),
				email: $('[name=email]').val(),
				def_status: $('[name=def_status]').val(),
			}
			if (data.persetujuan == 'penguji') {
				data.komentar_penguji = $('[name=komentar_penguji]').val()
			} else {
				data.komentar_pembimbing = $('[name=komentar_pembimbing]').val()
			}
			call('api/hasil_revisi/edit/' + penelitian_id, data).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Simpan')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Simpan')
				}
			})
		})

	})
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>