<?php $this->app->extend('template/admin') ?>

<?php $this->app->setVar('title', 'Seminar') ?>

<?php
 $url_cetak = base_url('admin/report2');
?> 

<?php $this->app->section() ?>
<div class="card">
	<form id="edit">
		<div class="card-header">
			<div class="card-title">Detail Seminar</div>
		</div>
		<div class="card-body">
			<div class="table-responsive">
				<table class="table table-hover">
					<div class="col-md-12">
                            <div class="form-group">
                                <label>Judul Proposal</label>
								<textarea readonly name="proposal_mahasiswa_judul" rows="3" class="form-control" placeholder=""></textarea>
                            </div>
                    </div>
					<tr>
						<td>Nama Mahasiswa</td>
						<th class="mahasiswa_nama">-</th>
					</tr>
					<tr>
						<td>Waktu Seminar</td>
						<th class="tanggal_jam">0000-00-00 00:00 AM</th>
					</tr>
					<tr>
						<td>Tempat</td>
						<th class="tempat">-</th>
					</tr>
					
					<tr>
						<td>Berita Acara</td>
						<th>
						
							<a href="<?= base_url() ?>admin/report6/cetak/<?= $seminar_id ?>" target="_blank">CETAK Berita Acara</a>
							
						
						</th>
					</tr>

			<div class="row mb-3">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>Masukan:</label>
                        <textarea name="masukan" rows="8" class="form-control"></textarea>
                    </div>
                </div>
            </div>


				
				</table>
				<input type="hidden" name="berita_acara">
				<input type="hidden" name="email">
				<input type="hidden" name="def_status">
			</div>
		</div>
		<div class="card-footer text-right">
			<a href="<?= base_url() ?>admin/seminar" class="btn btn-default">Kembali</a>
			<button type="submit" class="btn btn-primary btn-act">Simpan</button>
		</div>
	</form>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script>
	var seminar_id = '<?= $seminar_id ?>'

	$(document).ready(function() {

		function show() {
			call('api/seminar/details/' + seminar_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'mahasiswa/seminar';
					})
				} else {
					$('[name=proposal_mahasiswa_judul]').val(res.data.proposal_mahasiswa_judul);
					//$('.proposal_mahasiswa_judul').html(res.data.proposal_mahasiswa_judul);
					$('.mahasiswa_nama').html(res.data.mahasiswa_nama);
					$('.tanggal_jam').html(res.data.tanggal + ' ' + res.data.jam);
					$('.tempat').html(res.data.tempat);

					$('.bukti_pendaftaran').html(`<a href="` + base_url + `cdn/vendor/bukti_pendaftaran/` + res.data.bukti_pendaftaran + `" target="_blank">` + res.data.bukti_pendaftaran + `</a>`);
					$('.persetujuan').html(`<a href="` + base_url + `cdn/vendor/persetujuan/` + res.data.persetujuan + `" target="_blank">` + res.data.persetujuan + `</a>`);
					$('.file_proposal').html(`<a href="` + base_url + `cdn/vendor/file_proposal/` + res.data.file_proposal + `" target="_blank">` + res.data.file_proposal + `</a>`);
					$('.file_3A1').html(`<a href="` + base_url + `cdn/vendor/file_3A1/` + res.data.file_3A1 + `" target="_blank">` + res.data.file_3A1 + `</a>`);
					$('.file_3A2').html(`<a href="` + base_url + `cdn/vendor/file_3A2/` + res.data.file_3A2 + `" target="_blank">` + res.data.file_3A2 + `</a>`);
					$('.sk_tim').html(`<a href="` + base_url + `cdn/vendor/sk_tim/` + res.data.sk_tim + `" target="_blank">` + res.data.sk_tim + `</a>`);
					$('.bukti_konsultasi').html(`<a href="` + base_url + `cdn/vendor/bukti_konsultasi/` + res.data.bukti_konsultasi + `" target="_blank">` + res.data.bukti_konsultasi + `</a>`);
					
					
					$('.berita_acara').html((res.data.hasil.berita_acara) ? `<a href="` + base_url + `cdn/vendor/berita_acara/` + res.data.hasil.berita_acara + `">` + res.data.hasil.berita_acara + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-berita_acara">');
					

					$('[name=masukan]').val(res.data.hasil.masukan);

					$('[name=status]').val(res.data.hasil.status);
					$('[name=email]').val(res.data.email);
					$('[name=def_status]').val(res.data.hasil.status);
				}
			})
		}

		show()

		$(document).on('change', '[name=pilih-berita_acara]', function() {
			read('[name=pilih-berita_acara]', function(data) {
				$('[name=berita_acara]').val(data.result);
			})
		})



		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			call('api/hasil_seminar/edit1/' + seminar_id, $(this).serialize()).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Selesai')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Selesai')
				}
			})
		})

	})
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>