<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Tanda Tangan Digital</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f5f6fa;
            margin: 0;
            padding: 20px;
        }

        .card {
            max-width: 500px;
            margin: auto;
            background: #fff;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        }

        h3 {
            text-align: center;
            margin-bottom: 5px;
        }

        .subtitle {
            text-align: center;
            font-size: 13px;
            color: #666;
            margin-bottom: 20px;
        }

        canvas {
            width: 100%;
            height: 200px;
            border: 1px dashed #333;
            border-radius: 5px;
            background: #fff;
            touch-action: none;
        }

        .btn-group {
            display: flex;
            gap: 10px;
            margin-top: 15px;
        }

        button {
            flex: 1;
            padding: 10px;
            font-size: 14px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .btn-clear {
            background: #e74c3c;
            color: #fff;
        }

        .btn-save {
            background: #2ecc71;
            color: #fff;
            font-weight: bold;
        }

        .note {
            margin-top: 15px;
            font-size: 12px;
            color: #555;
            text-align: center;
        }
    </style>
</head>
<body>

<div class="card">

    <h3>Tanda Tangan Digital</h3>
    <div class="subtitle">
        <?= $nama_dosen ?? 'Dosen Penguji' ?><br>
        Silakan tanda tangan di area berikut
    </div>

    <canvas id="signature-pad"></canvas>

    <div class="btn-group">
        <button type="button" class="btn-clear" onclick="clearPad()">Ulangi</button>
        <button type="button" class="btn-save" onclick="saveSignature()">Simpan</button>
    </div>

    <div class="note">
        Tanda tangan ini sah untuk administrasi internal kampus
    </div>

    <form id="formTTD" method="post" action="<?= base_url('admin/report6/simpan_ttd') ?>">
        <input type="hidden" name="signature" id="signature">
    </form>

</div>

<script>
const canvas = document.getElementById('signature-pad');
const ctx = canvas.getContext('2d');

function resizeCanvas() {
    canvas.width = canvas.offsetWidth;
    canvas.height = 200;
}
resizeCanvas();
window.addEventListener('resize', resizeCanvas);

let drawing = false;

function getPos(e) {
    const rect = canvas.getBoundingClientRect();
    if (e.touches) {
        return {
            x: e.touches[0].clientX - rect.left,
            y: e.touches[0].clientY - rect.top
        };
    }
    return {
        x: e.clientX - rect.left,
        y: e.clientY - rect.top
    };
}

canvas.addEventListener('mousedown', e => { drawing = true; draw(e); });
canvas.addEventListener('mousemove', draw);
canvas.addEventListener('mouseup', () => drawing = false);
canvas.addEventListener('mouseleave', () => drawing = false);

canvas.addEventListener('touchstart', e => { drawing = true; draw(e); });
canvas.addEventListener('touchmove', draw);
canvas.addEventListener('touchend', () => drawing = false);

function draw(e) {
    if (!drawing) return;
    e.preventDefault();

    const pos = getPos(e);
    ctx.lineWidth = 2;
    ctx.lineCap = 'round';
    ctx.strokeStyle = '#000';

    ctx.lineTo(pos.x, pos.y);
    ctx.stroke();
    ctx.beginPath();
    ctx.moveTo(pos.x, pos.y);
}

function clearPad() {
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.beginPath();
}

function saveSignature() {
    const dataURL = canvas.toDataURL('image/png');
    document.getElementById('signature').value = dataURL;
    document.getElementById('formTTD').submit();
}
</script>

</body>
</html>
