<?php
// Helper untuk akses properti atau array
function get_val($obj_or_array, $key, $default = '') {
    if (is_array($obj_or_array) && isset($obj_or_array[$key])) return $obj_or_array[$key];
    if (is_object($obj_or_array) && isset($obj_or_array->$key)) return $obj_or_array->$key;
    return $default;
}

// Nama hari dari tanggal
$timestamp = strtotime(get_val($rs, 'tanggal'));
$hari_array = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
$namahari = $timestamp ? $hari_array[date('w', $timestamp)] : '';
?>

<link rel="stylesheet" href="<?= base_url('assets/css/printing-A4-half.css') ?>"/>
<script type="text/javascript">
    function cetak() {
       setTimeout(function(){ window.close();},300);
       window.print();    
    }
</script>
<title><?= $title ?></title>
<body onload="cetak();">
<div class="page">

<table width="100%">
    <tr>
        <td width="30%"><img src="<?= base_url('assets/img/logo_unmu.png') ?>"  height="30px" /></td>    
        <td width="40%" align="left">
            <b style="font-weight: bold;font-size:12px;"></b><br>
        </td>
    </tr>

    <tr>
        <td width="100%" align="center">
            <b style="font-weight: bold;font-size:12px;">FORM 5-A</b><br>
            <b style="font-weight: bold;font-size:12px;">BERITA ACARA UJIAN PROPOSAL</b><br>
            <b style="font-weight: bold;font-size:12px;">FAKULTAS KEDOKTERAN UNIVERSITAS MUHAMMADIYAH SURABAYA</b><br>
        </td>
    </tr>        
</table>
<br/>

<p>
Pada hari <?= $namahari ?>, tanggal <?= date('d F Y', strtotime(get_val($rs, 'tanggal'))) ?>, telah dilaksanakan Sidang Tugas Akhir dari pukul <?= get_val($rs, 'jam') ?> WIB s/d selesai, bertempat di Ruang Sidang/Ujian Fakultas Kedokteran, atas nama mahasiswa berikut :
</p>

<div style="width:100%;display:inline-block;">
    <div style="width:100%;float:left;">
        <table width="100%" style="color: #000;">
            <tr>
                <td width="20%">Nama Mahasiswa</td>
                <td width="2%">:</td>
                <td width="73%"><?= get_val($rs, 'nama_mahasiswa') ?></td>
            </tr>
            <tr>
                <td width="20%">NIM</td>
                <td width="2%">:</td>
                <td width="200%"><?= get_val($rs, 'nim') ?></td>
            </tr>
            <tr>
                <td width="20%">Program Studi</td>
                <td width="2%">:</td>
                <td width="200%">S1 Pendidikan Dokter</td>
            </tr>
            <tr>
                <td width="20%">Judul Tugas Akhir</td>
                <td width="2%">:</td>
                <td width="200%"><?= get_val($rs, 'proposal_mahasiswa_judul') ?></td>
            </tr>
            <tr>
                <td width="20%">Dengan Hasil</td>
                <td width="2%">:</td>
                <td width="200%"><?= get_val($rs, 'ket') ?></td>
            </tr>				
        </table>
    </div>
</div>
<br/><br/>

<p>Hasil Penilaian : </p>

<table width="100%" class="tabel-laporan" border=1>
    <thead>
        <tr>
            <th width="40%" align="left">Nama Dosen Penguji</th>
            <th width="25%" align="left">Jabatan</th>
            <th width="25%" align="center">Masukan</th>
            <th width="10%" align="right">Nilai</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><?= get_val($rs, 'dosen3') ?></td>
            <td>Penguji</td>
            <td><?= get_val($rs, 'masukan3') ?></td>
            <td><?= get_val($rs, 'nilai3') ?></td>
        </tr>
        <tr>
            <td><?= get_val($rs, 'dosen1') ?></td>
            <td>Pembimbing 1</td>
            <td><?= get_val($rs, 'masukan1') ?></td>
            <td><?= get_val($rs, 'nilai1') ?></td>
        </tr>
        <tr>
            <td><?= get_val($rs, 'dosen2') ?></td>
            <td>Pembimbing 2</td>
            <td><?= get_val($rs, 'masukan2') ?></td>
            <td><?= get_val($rs, 'nilai2') ?></td>
        </tr>
        <tr>
            <td></td>
            <td></td>
            <td><b>TOTAL</b></td>
            <td><?= get_val($rs, 'nilai1',0) + get_val($rs, 'nilai2',0) + get_val($rs, 'nilai3',0) ?></td>
        </tr>
    </tbody>
</table>

</div>
</body>
