<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Berita Acara Ujian Proposal</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            color: #000;
        }

        .page {
            padding: 30px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .header td {
            vertical-align: middle;
        }

        .judul {
            font-weight: bold;
            font-size: 14px;
        }

        hr {
            border: 1px solid #000;
            margin: 15px 0 20px;
        }

        .tbl-detail td {
            padding: 4px 0;
        }

        .tbl-nilai th,
        .tbl-nilai td {
            border: 1px solid #000;
            padding: 6px;
        }

        .tbl-nilai th {
            background: #f2f2f2;
            text-align: center;
        }

        .ttd {
            margin-top: 50px;
            text-align: center;
        }

        .ttd img {
            height: 60px;
        }
    </style>
</head>
<body>
<div class="page">

    <!-- HEADER -->
    <table class="header">
        <tr>
            <td width="20%">
                <img src="<?= base_url('assets/img/logo_unmu.png') ?>" height="60">
            </td>
            <td width="80%" align="center">
                <div class="judul">FORM 5-A</div>
                <div class="judul">BERITA ACARA UJIAN PROPOSAL</div>
                <div style="font-size:12px;">
                    FAKULTAS KEDOKTERAN<br>
                    UNIVERSITAS MUHAMMADIYAH SURABAYA
                </div>
            </td>
        </tr>
    </table>

    <hr>

    <!-- DATA MAHASISWA -->
    <p style="text-align:justify;">
        Pada hari <b><?= $namahari ?></b>,
        tanggal <b><?= date('d F Y', strtotime($first['tanggal'])) ?></b>,
        pukul <b><?= $first['jam'] ?> WIB</b>,
        bertempat di Fakultas Kedokteran Universitas Muhammadiyah Surabaya,
        telah dilaksanakan Ujian Proposal atas nama mahasiswa:
    </p>

<table class="tbl-detail">
    <tr>
        <td width="25%">Nama Mahasiswa</td>
        <td width="3%">:</td>
        <td><?= $first['nama_mahasiswa'] ?></td>
    </tr>
    <tr>
        <td>NIM</td>
        <td>:</td>
        <td><?= $first['nim'] ?></td>
    </tr>
        <tr>
            <td>Program Studi</td>
            <td>:</td>
            <td>S1 Pendidikan Dokter</td>
        </tr>    
    <tr>
        <td>Judul Tugas Akhir</td>
        <td>:</td>
        <td><?= $first['proposal_mahasiswa_judul'] ?></td>
    </tr>
    <tr>
        <td>Dengan Hasil</td>
        <td>:</td>
        <td><b><?= $first['ket'] ?></b></td>
    </tr>
</table>

    <br>


<!-- TABEL NILAI -->
<?php
$total_nilai = 0;
foreach ($rs as $row) {
    if (isset($row['nilai'])) {
        $total_nilai += (int) $row['nilai'];
    }
}
?>
<table class="tbl-nilai">
    <thead>
        <tr>
            <th>Nama Dosen Penguji</th>
            <th>Jabatan</th>
            <th>Masukan</th>
            <th>Nilai</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($rs as $dosen): ?>
        <tr>
            <td><?= $dosen['nama_dosen'] ?></td>
            <td><?= $dosen['jabatan'] ?></td>
            <td><?= $dosen['masukan'] ?></td>
            <td align="right"><?= $dosen['nilai'] ?></td>
        </tr>
        <?php endforeach; ?>

        <tr>
            <td colspan="3" align="center"><b>TOTAL</b></td>
            <td align="right"><b><?= $total_nilai ?></b></td>
        </tr>
    </tbody>
</table>


    <!-- TANDA TANGAN -->
    <table width="100%" style="margin-top:50px;">
        <tr>
            <td width="33%" align="center"><b>Pembimbing 1</b></td>
            <td width="33%" align="center"><b>Pembimbing 2</b></td>
            <td width="33%" align="center"><b>Penguji</b></td>
        </tr>
        <tr>
            <td height="80" align="center">
                <?php if (!empty($first['file_ttd'])): ?>
                    <img src="<?= base_url('assets/ttd/'.$first['file_ttd']) ?>"><br>
                <?php endif; ?>
            </td>
            <td align="center"><?= $first['dosen2'] ?></td>
            <td align="center"><?= $first['dosen3'] ?></td>
        </tr>        
        <tr>
            <td height="80" align="center"><?= $first['dosen1'] ?></td>
            <td align="center"><?= $first['dosen2'] ?></td>
            <td align="center"><?= $first['dosen3'] ?></td>
        </tr>
    </table>


    <!-- TANDA TANGAN -->
    <table class="ttd">
        <tr>
            <?php foreach ($rs as $dosen): ?>
            <td width="33%">
                <?= $dosen['jabatan'] ?><br><br>
                <?php if (!empty($dosen['file_ttd'])): ?>
                    <img src="<?= base_url('assets/ttd/'.$dosen['file_ttd']) ?>"><br>
                <?php endif; ?>
                <?= $dosen['nama_dosen'] ?>
            </td>
            <?php endforeach; ?>
        </tr>
    </table>

</div>
</body>
</html>
