<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <title>Laporan Seminar Proposal</title>

    <!-- Include file CSS Bootstrap -->
    <link href="<?php echo base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet">

    <!-- Include File jQuery -->
    <script src="<?php echo base_url('assets/js/jquery.min.js') ?>"></script>


</head>
<body>


  
  

    <div style="padding: 15px;">
        <h3 style="margin-top: 0;"><b>Laporan Nilai Akhir Skripsi Periode Tanggal</b></h3>
        <hr />

        <form method="get" action="<?php echo base_url('admin/report3') ?>">
            <div class="row">
                <div class="col-sm-6 col-md-4">
                    <div class="form-group">
                        <label>Filter Tanggal</label>
                        <div class="input-group">
                            <input type="date" name="tgl_awal" value="<?= @$_GET['tgl_awal'] ?>" class="form-control tgl_awal" placeholder="Tanggal Awal" autocomplete="off">
                            <span class="input-group-addon">s/d</span>
                            <input type="date" name="tgl_akhir" value="<?= @$_GET['tgl_akhir'] ?>" class="form-control tgl_akhir" placeholder="Tanggal Akhir" autocomplete="off">
                        </div>
                    </div>
				
					
                </div>
            </div>

            <button type="submit" name="filter" value="true" class="btn btn-primary">TAMPILKAN</button>

            <?php
            if(isset($_GET['filter'])) // Jika user mengisi filter tanggal, maka munculkan tombol untuk reset filter
                echo '<a href="'.base_url('admin/report3').'" class="btn btn-default">RESET</a>';
            ?>
        </form>

        <hr />

        <div style="margin-top: 5px;">
            <a href="<?php echo $url_cetak ?>">CETAK PDF</a>
        </div>

        <div class="table-responsive" style="margin-top: 10px;">
            <table id='tablemodul1' width=100% border=1>
                <thead>
					
				  <tr>
				    <th width='20px' rowspan='2'>No.</th>
					<th width='20px' rowspan='2'>NIM</th>
					<th width='200px' rowspan='2'>Nama Mahasiswa</th>
					<th width='350px' rowspan='2'>Judul Skripsi</th>
					<th width='100px' rowspan='2'>Jenis Skripsi</th>
					<th colspan='3' style='text-align:center'>Nilai Ujian Proposal</th>
					<th width='100px' rowspan='2' style='text-align:center'>Nilai Ujian Proposal</br>(20%)</th>
				  </tr>
				  <tr>
					<th width='50px' style='text-align:center'>Pemb.1</th>
					<th width='50px' style='text-align:center'>Pemb.2</th>
					<th width='50px' style='text-align:center'>Penguji</th>
				  </tr>				
					
                </thead>
                <tbody>
                    <?php
                    if(empty($transaksi)){ // Jika data tidak ada
                        echo "<tr><td colspan='5'>Data tidak ada</td></tr>";
                    }else{ // Jika jumlah data lebih dari 0 (Berarti jika data ada)
						$no=0;
                        foreach($transaksi as $data){ // Looping hasil data transaksi
							$no++;
                            $tgl = date('d-m-Y', strtotime($data->tanggal)); // Ubah format tanggal jadi dd-mm-yyyy
							
							$total1 =  ($data->nilai1*0.25) + ($data->nilai2*0.25) + ($data->nilai3*0.50);
							$total2 =  ($data->nilaia*0.25) + ($data->nilaib*0.25) + ($data->nilaic*0.50);
							$total =  ($total1*0.20) + ($total2*0.80);
							
							if($total>=80){
								$predikat = 'A';
							}else if($total>=72){
								$predikat = 'AB';
							}else if($total>=64){
								$predikat = 'B';
							}else if($total>=56){
								$predikat = 'BC';
							}else if($total>=48){
								$predikat = 'C';
							}else if($total>=40){
								$predikat = 'D';
							}else{
								$predikat = 'E';
							}		
							
							
	
                            echo "<tr>";
							echo "<td><center>".$no."</center></td>";
							echo "<td>".$data->nim."</td>";
							echo "<td>".$data->nama_mahasiswa."</td>";
							echo "<td>".$data->proposal_mahasiswa_judul."</td>";
							echo "<td>".$data->ket."</td>";
							echo "<td>".$data->nilai1."</td>";
							echo "<td>".$data->nilai2."</td>";
							echo "<td>".$data->nilai3."</td>";
							echo "<td>".$total1."</td>";
                            echo "</tr>";
                        }
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Include File JS Bootstrap -->
    <script src="<?php echo base_url('assets/js/bootstrap.min.js') ?>"></script>


    <!-- Include File JS Custom (untuk fungsi Datepicker) -->
    <script src="<?php echo base_url('assets/js/custom.js') ?>"></script>

    <script>
    $(document).ready(function(){
        setDateRangePicker(".tgl_awal", ".tgl_akhir")
    })
    </script>
</body>
</html>