<?php $this->app->extend('template/dosen') ?>
<?php $this->app->setVar('title', 'Seminar') ?>
<?php $this->app->section() ?>

<div class="card">
    <form id="edit">
        <div class="card-header">
            <div class="card-title">Detail Seminar Pembimbing</div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Judul Proposal</label>
                            <textarea readonly name="proposal_mahasiswa_judul" rows="3" class="form-control"></textarea>
                        </div>
                    </div>
                    <tr><td>Mahasiswa</td><th class="mahasiswa_nama">-</th></tr>
                    <tr><td>Waktu Seminar</td><th class="tanggal_jam">0000-00-00 00:00 AM</th></tr>
                    <tr><td>Tempat</td><th class="tempat">-</th></tr>
                </table>

                <input type="hidden" name="dosen1">
                <input type="hidden" name="dosen2">
                <input type="hidden" name="dosen3">
            </div>
        </div>

        <div class="card-body" id="preview">
            <?php foreach ($files as $file): 
                $file_path = base_url('cdn/vendor/file_proposal/'.$file->nama_foto); ?>
                <tr>
                    <td><iframe src="<?= $file_path ?>" width="250" height="300" frameborder="0" scrolling="auto"></iframe></td>
                    <td style="text-align:center;">
                        <a href="#" onclick="kirimData('<?= $file->token ?>')">Hapus</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </div>
    </form>
</div>

<div class="card-footer text-right">
<?php if ($this->session->userdata('level') == 2): ?>
    <button class="btn btn-success" data-toggle="modal" data-target="#modalTtd">
        ✍️ Tanda Tangani
    </button>
<?php endif; ?>

    <a href="<?= base_url('dosen/report6/cetak/'.$seminar_id) ?>" target="_blank" class="btn btn-primary">🖨 Cetak PDF</a>
    <a href="<?= base_url() ?>dosen/seminar" class="btn btn-default">Kembali</a>
</div>

<!-- MODAL TANDA TANGAN -->
<div class="modal fade" id="modalTtd" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Tanda Tangan Digital</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body text-center">
        <canvas id="signature-pad" width="700" height="250" style="border:1px solid #ccc"></canvas>
        <div id="ttd-preview" style="margin-top:10px;"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-warning" id="clear-ttd">Ulangi</button>
        <button type="button" class="btn btn-primary" id="save-ttd">Simpan</button>
      </div>
    </div>
  </div>
</div>

<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script src="https://cdn.jsdelivr.net/npm/signature_pad@4.0.0/dist/signature_pad.umd.min.js"></script>
<script>
var seminar_id = '<?= $seminar_id ?>';
var base_url = '<?= base_url() ?>';

$(document).ready(function() {

    // Inisialisasi SignaturePad
    var canvas = document.getElementById('signature-pad');
    var signaturePad = new SignaturePad(canvas, {
        backgroundColor: 'rgba(255, 255, 255, 0)',
        penColor: 'black'
    });

    // Tombol Ulangi
    $('#clear-ttd').click(function() {
        signaturePad.clear();
        $('#ttd-preview').html('');
    });

    // Tombol Simpan
$('#save-ttd').click(function() {
    if(signaturePad.isEmpty()) {
        alert("Silakan tanda tangani dulu!");
        return;
    }
    var dataURL = signaturePad.toDataURL('image/png');

    $.ajax({
        type: 'POST',
        url: base_url + 'dosen/seminar/simpan_ttd',
        data: { seminar_id: seminar_id, image: dataURL },
        success: function(res) {
            res = JSON.parse(res);
            if(res.status) {
                alert('Tanda tangan tersimpan!');
                $('#modalTtd').modal('hide');
                // Tambahkan ?v=timestamp agar browser tidak pakai cache
                $('#ttd-preview').html('<img src="'+base_url+'assets/ttd/'+res.file+'?v='+new Date().getTime()+'" width="300">');
            } else {
                alert('Gagal menyimpan tanda tangan!');
            }
        },
        error: function() {
            alert('Terjadi kesalahan, coba lagi.');
        }
    });
});


    // Load tanda tangan jika sudah ada
    function loadTtd() {
        $.get(base_url + 'dosen/seminar/ambil_ttd/' + seminar_id, function(res) {
            res = JSON.parse(res);
            if(res.tanda_tangan) {
                $('#ttd-preview').html('<img src="'+res.tanda_tangan+'" width="300">');
            }
        });
    }
    loadTtd();

    // Fungsi hapus file proposal
    window.kirimData = function(nilai) {
        $.post(base_url + 'remove_foto/post', { token: nilai }, function() {
            location.reload();
        });
    };

    // Load data seminar seperti kode lama (jika ada)
    function show() {
        call('api/seminar/details/' + seminar_id).done(function(res) {
            if(res.error) {
                notif(res.message,'warning').then(function(){ window.location = base_url + 'dosen/seminar'; });
            } else {
                $('[name=proposal_mahasiswa_judul]').val(res.data.proposal_mahasiswa_judul);
                $('.mahasiswa_nama').html(res.data.mahasiswa_nama);
                $('.tanggal_jam').html(res.data.tanggal + ' ' + res.data.jam);
                $('.tempat').html(res.data.tempat);
                $('[name=dosen1]').val(res.data.dosen1);
                $('[name=dosen2]').val(res.data.dosen2);
                $('[name=dosen3]').val(res.data.dosen3);
            }
        });
    }
    show();

});
</script>
<?php $this->app->endSection('script') ?>
<?php $this->app->init() ?>
