<?php $this->app->extend('template/mahasiswa') ?>

<?php $this->app->setVar('title', "Hasil Kegiatan") ?>

<?php $this->app->section() ?>


<div class="card">
    <div class="card-header">
        <div class="card-title">Data Hasil Kegiatan</div>
        <div class="col-md text-right">

            <button class="btn btn-primary btn-tambah" type="button" data-toggle="modal" data-target="#tambah" data-dosen_id=<?= $rs->dosen_id ?> data-dosen2_id=<?= $rs->dosen2_id ?> data-judul=<?= $rs->judul ?> 
            data-nama=<?= $rs->nama ?> data-nim=<?= $rs->nim ?> data-email=<?= $rs->email ?> data-nomor_telepon=<?= $rs->nomor_telepon ?>   >
                <i class="fa fa-plus"></i>
                Tambah
            </button>

        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="data-hasil-kegiatan">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>NIM</th>
                        <th>Nama</th>
                        <th>Judul</th>
                        <th>Nomer Surat</th>
                        <th>Perihal</th>
                        <th>Cetak Surat</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="tambah">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="tambah">
                <div class="modal-header">
                    <div class="modal-title">Tambah Hasil Kegiatan</div>
                </div>
            
            <div class="modal-body">


                <div class="row p-2">
                    <div class="col-5">Nama Mahasiswa</div>
                    <td width="73%"><?= $rs->nama ?></td>
                    <input type="text" name="xnama" value='<?= $rs->nama ?>'>
                </div>
                <div class="row p-2">
                    <div class="col-5">NIM</div>
                    <td width="73%"><?= $rs->nim ?></td>
                    <input type="hidden" name="xnim" value='<?= $rs->nim ?>'>
                </div>                
                <div class="row p-2">
                    <div class="col-5">Email</div>
                    <td width="73%"><?= $rs->email ?></td>
                    <input type="hidden" name="xemail" value='<?= $rs->email ?>'>
                </div>
                <div class="row p-2">
                    <div class="col-5">Nomor Telepon</div>
                    <td width="73%"><?= $rs->nomor_telepon ?></td>
                    <input type="hidden" name="xnomor_telepon" value='<?= $rs->nomor_telepon ?>'>
                </div></br>


                        <tr>
							<td>Perihal Surat</td>
                            <td colspan="3">
							<select name="jenis_surat" class="form-control">
								<option value="Etik">Etik</option>
								<option value="Penelitian">Penelitian</option>
							</select>
                            </td>
                        </tr></br>

                <tr><th scope='row'>Judul</th>
                <td><textarea class='form-control' name='judul' style='height:100px'><?= $rs->judul ?></textarea></td>
                </tr></br>              

                
                    <div class="form-group">
                        <label>Instansi / Lembaga yang dituju</label>
                        <input type="text" name="instansi" placeholder="Masukkan Instansi / Lembaga yang dituju" class="form-control">
                    </div>

                    <div class="form-group">
                        <label>Dosen Pembimbing 1</label>
                        <select name="dosen_id" class="form-control">
                            <option value="">- Pilih Dosen -</option>
                        </select>
                    </div>
                
                    <div class="form-group">
                        <label>Dosen Pembimbing 2</label>
                        <select name="dosen2_id" class="form-control">
                            <option value="">- Pilih Dosen -</option>
                        </select>
                    </div>
            

                </div>

                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>

            </div>

            </form>
        </div>
    </div>
</div>



<div class="modal fade" id="hapus">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="hapus">
                <div class="modal-header">
                    <div class="modal-title">Hapus Hasil Kegiatan</div>
                </div>
                <div class="modal-body">
                    <input type="hidden" class="id">
                    <input type="hidden" class="file">
                    <input type="hidden" class="file_kegiatan">
                    <p>Anda yakin ingin menghapus ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>cdn/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<script src="<?= base_url() ?>cdn/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>cdn/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script>

$(document).ready(function() {



            call('api/dosen/').done(function(req) {
                dosen = '<option value="">- Pilih Dosen -</option>';
                if (req.data) {
                    $.each(req.data, function(index, obj) {
                        dosen += '<option value="' + obj.id + '">' + obj.nama + '</option>';
                    })
                }

                $('[name=dosen_id]').html(dosen);
                $('[name=dosen2_id]').html(dosen);

            })
        


$(document).on('change', 'form#tambah [name=pilih-file_kegiatan]', function() {
    read('[name=pilih-file_kegiatan]', function(data) {
        $('[name=file_kegiatan]').val(data.result);
    })
});

$(document).on('submit', 'form#tambah', function(e) {
    e.preventDefault()
    call('api/hasil_kegiatan/tambah', $(this).serialize()).done(function(res) {
        if (res.error) {
            notif(res.message, 'error', true);
        } else {

            //$('form#tambah [name]').val('');

            $('form#tambah [name=instansi]').val('');

            $('div#tambah').modal('hide');
            notif(res.message, 'success');
            show();


        }
    })
});



        $(document).on('click', 'button.btn-tambah', function() {
            $('form#tambah [name=dosen_id]').val($(this).data('dosen_id'));
            $('form#tambah [name=dosen2_id]').val($(this).data('dosen2_id'));
        })




        $(document).on('click', 'button.btn-hapus', function() {
            $('form#hapus .id').val($(this).data('id'));
            $('form#hapus .file').val($(this).data('file'));
            $('form#hapus .file_kegiatan').val($(this).data('file_kegiatan'));
        });

        $(document).on('submit', 'form#hapus', function(e) {
            e.preventDefault()
            const id = $('form#hapus .id').val();
            const file = $('form#hapus .file').val();
            const file_kegiatan = $('form#hapus .file_kegiatan').val();

            $.ajax({
                url: base_url + 'api/hasil_kegiatan/hapus/' + id,
                type: 'post',
                data: {
                    file: file
                },
                success: function(res) {
                    $('div#hapus').modal('hide');
                    notif(res.message, 'success');
                    show();
                }
            })
        });



function show() {
    $('#data-hasil-kegiatan').DataTable().destroy();
            $('#data-hasil-kegiatan').DataTable({
                "deferRender": true,
                "ajax": {
                    "url": base_url + '/api/hasil_kegiatan',
                    "method": "POST",
                    "data": {
                        mahasiswa_id: '<?= $this->session->userdata('id') ?>'
                    },                    
                    "dataSrc": "data"
                },
                "columns": [{
                        data: null,
                        render: function(data, type, row, meta) {
                            return meta.row + meta.settings._iDisplayStart + 1;
                        }
                    },
                    {
                        data: "nim"
                    },
                    {
                        data: "nama_mahasiswa"
                    },
                    {
                        data: "judul"
                    },
                    {
                        data: "nomer_surat"
                    },
                    {
                        data: "hal"
                    },
                    {
                        data: null,
                        render: function(data) {
                        
if (data.status == '1') {

    return '<a href="' + base_url + 'cdn/vendor/file/' + data.file + '" target="_blank">' + data.file + '</a>';

} else {

    return `
                            <div class="text-center"><button class="btn btn-sm btn-danger btn-hapus" type="button" data-toggle="modal" data-target="#hapus" data-id="` + data.id + `" data-nomer_surat="` + data.nomer_surat + `">
                                <i class="fa fa-trash"></i>
                            </button></div>
                            `;

}                  
                            




                        }
                    }
                ],
                "language": {
                    "zeroRecords": "data tidak tersedia"
                }
            });
}

show();

})




</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>