<?php $this->app->extend('template/mahasiswa') ?>
<?php $this->app->setVar('title', 'Revisi') ?>
<?php $this->app->section('content') ?>

<?php
$previous_page = $this->session->userdata('current_page') ?? base_url('mahasiswa/proposal');
?>

<div class="card">
<form id="edit">

<div class="card-header">
    <div class="card-title">Detail Revisi</div>
</div>

<div class="card-body">
<div class="row">
    <div class="col-md-4">
        <label>Judul Proposal</label>
        <textarea readonly name="proposal_mahasiswa_judul" rows="3" class="form-control"></textarea>
    </div>

    <div class="col-md-4">
        <label>Ringkasan</label>
        <textarea name="ringkasan" rows="3" class="form-control"></textarea>
    </div>

    <div class="col-md-4">
        <label>Jenis Skripsi</label>
        <select name="jenis_skripsi" class="form-control">
            <option value="">- Pilih -</option>
            <option value="1">Skripsi Konvensional</option>
            <option value="2">Sistematik Review</option>
            <option value="3">Case Report</option>
        </select>
    </div>


                <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Pembimbing 1</label>
								<select name="dosen_id" id="dosen_id" class="form-control">
										<option value="">-- Pilih Dosen --</option>
										<?php foreach ($dosen as $row): ?>
											<option value="<?php echo $row->id; ?>"><?php echo $row->nama; ?></option>
										<?php endforeach; ?>
								</select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Pembimbing 2</label>
								<select name="dosen2_id" id="dosen2_id" class="form-control">
										<option value="">-- Pilih Dosen --</option>
										<?php foreach ($dosen as $row): ?>
											<option value="<?php echo $row->id; ?>"><?php echo $row->nama; ?></option>
										<?php endforeach; ?>
								</select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Penguji</label>
								<select id="dosen_penguji_display" class="form-control" disabled>
									<option value="">-- Dosen Penguji --</option>
									<?php foreach ($dosen as $row): ?>
										<option value="<?= $row->id ?>"><?= $row->nama ?></option>
									<?php endforeach; ?>
								</select>

								<input type="hidden" name="dosen_penguji_id" id="dosen_penguji_id">							
                            </div>
                        </div>						
                </div>

</div>
</div>

<div class="card-footer text-right">
    <a href="<?= base_url('mahasiswa/proposal') ?>" class="btn btn-default">Kembali</a>
    <button type="submit" class="btn btn-primary btn-act">Simpan</button>
</div>

</form>
</div>

<!-- UPLOAD -->
<div class="card mt-3 border-primary">
    <div class="card-header bg-primary text-white">
        <strong>⬆️ Upload Dokumen</strong>
    </div>
    <div class="card-body">
        <form id="dropzone" class="dropzone"></form>
    </div>
</div>

<!-- DOKUMEN -->
<div class="card mt-3">
    <div class="card-header">
        <strong>📄 Dokumen Tersimpan</strong>
    </div>
    <div class="card-body">
        <div class="row" id="dokumenTersimpan"></div>
    </div>
</div>



<?php $this->app->endSection('content') ?>
<?php $this->app->section('script') ?>

<link rel="stylesheet" href="<?= base_url('assets/dropzone/dropzone.min.css') ?>">
<script src="<?= base_url('assets/dropzone/jquery-3.3.1.min.js') ?>"></script>
<script src="<?= base_url('assets/dropzone/dropzone.min.js') ?>"></script>


<script>
var seminar_id	= '<?= $seminar_id ?>';
var dosen_id 	= '<?= $dosen_id ?>';

Dropzone.autoDiscover = false;

function loadDokumen(){
    $.get("<?= base_url('dropzone-upload-image/get') ?>", function(html){
        $("#dokumenTersimpan").html(html);
    });
}

var dz = new Dropzone("#dropzone", {
    url: "<?= base_url('dropzone-upload-image/post') ?>",
    maxFilesize: 5,
    acceptedFiles: ".pdf",
    paramName: "file",
    dictDefaultMessage: "Letakkan dokumen di sini"
});

dz.on("sending", function(file, xhr, formData){
    file.token = Math.random().toString(36).substr(2);
    formData.append("token_foto", file.token);
});

dz.on("success", function(){
    dz.removeAllFiles();
    loadDokumen(); // 🔥 AJAX reload tanpa refresh
});

function hapusFile(token){
    $.post("<?= base_url('remove_foto/post') ?>", {token:token}, function(){
        loadDokumen();
    });
}

$(document).ready(function(){
    loadDokumen(); // load awal
});

// END DROPZONE

	$(document).ready(function() {

		function show() {
			call('api/proposal_mahasiswa/details/' + seminar_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'mahasiswa/proposal';
					})
				} else {
					console.log(res.data)

					
					$('.tanggal_jam').html(res.data.tanggal + ' ' + res.data.jam);
					$('[name=tanggal]').val(res.data.tanggal);
					$('[name=jam]').val(res.data.jam);
					$('[name=ringkasan]').val(res.data.ringkasan);
					$('[name=proposal_mahasiswa_judul]').val(res.data.proposal_mahasiswa_judul);
                    
                    $('[name=dosen_id]').val(res.data.dosen1);
                    $('[name=dosen2_id]').val(res.data.dosen2);
					$('[name=dosen_penguji_id]').val(res.data.dosen3);

                    $('[name=jenis_skripsi]').val(res.data.jenis_skripsi);

					$('.file_3A2a').html(`<a href="` + base_url + `cdn/vendor/file_3A2/` + res.data.file_3A2 + `" target="_blank">` + res.data.file_3A2 + `</a>`);
					$('.file_3A2').html(('') ? `<a href="` + base_url + `cdn/vendor/file_3A2/` + '' + `">` + '' + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-file_3A2">');
					

					$('#dosen_penguji_display').val(res.data.dosen3);
					$('#dosen_penguji_id').val(res.data.dosen3);					

				}
			})
		}

		show()


		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			call('api/proposal_mahasiswa/edit3/' + seminar_id, $(this).serialize()).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Selesai')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Selesai')
				}
			})
		})


	})



function kirimData(nilai) {

    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>remove_foto/post",
        data: { token: nilai },
        success: function(response) {
        
		window.location.href = '<?php echo $previous_page;?>';


        }
    });
}	

</script>

<?php $this->app->endSection('script') ?>
<?php $this->app->init() ?>