<?php $this->app->extend('template/mahasiswa') ?>

<?php $this->app->setVar('title', 'Revisi') ?>

<?php $this->app->section() ?>


<?php
// Ambil session current_page, kalau tidak ada pakai default URL
$previous_page = $this->session->userdata('current_page') ?? base_url('mahasiswa/proposal');
?>

<div class="card">
	<form id="edit">
	<div class="card-header">
		<div class="card-title">Detail Revisi</div>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table table-hover">

				<div class="row">
					<div class="col-md-4">
                            <div class="form-group">
                                <label>Judul Proposal</label>
								<textarea readonly name="proposal_mahasiswa_judul" rows="3" class="form-control" placeholder=""></textarea>
                            </div>
                    </div>
					
					<div class="col-md-4">
                            <div class="form-group">
                                <label>Ringkasan</label>
								<textarea name="ringkasan" rows="3" class="form-control" placeholder="Masukkan ringkasan"></textarea>
                            </div>
                    </div>
                    
                    <div class="col-md-4">
                            <div class="form-group">
                                <label>Jenis Skripsi <span class="text-danger">*</span></label>
                                <select name="jenis_skripsi" class="form-control">
                                    <option value="">- Pilih Jenis Skripsi -</option>
                                    <option value="1">Skripsi Konvensional</option>
                                    <option value="2">Sistematik Review</option>
                                    <option value="3">Case Report</option>
                                </select>
                            </div>	
                    </div>


				</div>
				
                <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Pembimbing 1</label>
								<select name="dosen_id" id="dosen_id" class="form-control">
										<option value="">-- Pilih Dosen --</option>
										<?php foreach ($dosen as $row): ?>
											<option value="<?php echo $row->id; ?>"><?php echo $row->nama; ?></option>
										<?php endforeach; ?>
								</select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Pembimbing 2</label>
								<select name="dosen2_id" id="dosen2_id" class="form-control">
										<option value="">-- Pilih Dosen --</option>
										<?php foreach ($dosen as $row): ?>
											<option value="<?php echo $row->id; ?>"><?php echo $row->nama; ?></option>
										<?php endforeach; ?>
								</select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Penguji</label>
								<select id="dosen_penguji_display" class="form-control" disabled>
									<option value="">-- Dosen Penguji --</option>
									<?php foreach ($dosen as $row): ?>
										<option value="<?= $row->id ?>"><?= $row->nama ?></option>
									<?php endforeach; ?>
								</select>

								<input type="hidden" name="dosen_penguji_id" id="dosen_penguji_id">							
                            </div>
                        </div>						
                </div>


			</table>



		</div>

	</div>
		
	
	<div class="card-footer text-right">
		<a href="<?= base_url() ?>mahasiswa/proposal" class="btn btn-default">Kembali</a>
		<button type="submit" class="btn btn-primary btn-act">Simpan</button>
	</div>

	</form>


	<div class="card-body">

<?php

	$dosenid = $dosen_id;

	if($dosenid <> 'undefined'){


	}else{


	echo '
	
		<form action="" class="dropzone" id="dropzone">

		</form>';


	}

?>	

		<div id="preview">

			<?php		
				foreach ($files as $file){
					$dir	= base_url() . 'cdn/vendor/file_proposal/';
					$file_path = $dir . $file->nama_foto;
					$icon_path = $dir . 'icon-delete.png';
			?>
			<tr>
				
				<!--<td><embed src="<?= $file_path ?>" type="application/pdf" width="20%" height="100px"></td>-->

				<td><iframe src="<?= $file_path ?>" width="250" height="300" frameborder="0" scrolling="auto"></iframe></td>

				<td style="text-align:center;">
					<a href="#" onclick="kirimData(<?php echo $file->token; ?>)">Hapus </a>
				</td>
			</tr>
			<?php
				}
			?>

		</div>


		<a href="<?php echo $previous_page;?>"><button>Refresh</button></a>
		

	</div>


</div>



<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>


    <link href="<?php echo base_url(); ?>assets/dropzone/bootstrap.min.css" rel="stylesheet" type="text/css"/> 
    <link href="<?php echo base_url(); ?>assets/dropzone/dropzone.min.css" rel="stylesheet" type="text/css"/>
    <script src="<?php echo base_url(); ?>assets/dropzone/dropzone.min.js" type="text/javascript"></script>
    <script src="<?php echo base_url(); ?>assets/dropzone/jquery-3.3.1.min.js" type="text/javascript"></script>  


<script>

var seminar_id = '<?= $seminar_id ?>';
var dosen_id = '<?= $dosen_id ?>';

if (dosen_id > 0){

}else{

Dropzone.autoDiscover = false;

var foto_upload= new Dropzone(".dropzone",{
url: "<?= base_url() ?>dropzone-upload-image/post",    
maxFilesize: 5,
method:"post",

//acceptedFiles: ".jpeg,.jpg,.png,.gif,.pdf,.doc,.docx",
acceptedFiles: ".pdf",

paramName:"file",
dictInvalidFileType:"Type file ini tidak dizinkan",
dictDefaultMessage: "Sebelum Simpan, Letakkan dokumen di sini (atau klik) untuk mengambil/mengunggah",
addRemoveLinks:true,

success: function(file, response) {

    // Handle success, misalnya menyimpan data file ke database atau menampilkan thumbnail
    console.log("File berhasil diunggah:", file, response);

  },
  error: function(file, response) {
    // Handle error
    console.error("Gagal mengunggah file:", file, response);
  },


});

//Event ketika Memulai mengupload
foto_upload.on("sending",function(a,b,c){
	
	a.token=Math.random();
	c.append("token_foto",a.token); //Menmpersiapkan token untuk masing masing foto
	c.append("seminar_id",seminar_id);

});


//Event ketika foto dihapus
foto_upload.on("removedfile",function(a){
	var token=a.token;
	$.ajax({
		type:"post",
		data:{token:token},
        url: "<?= base_url() ?>remove_foto/post",
		cache:false,
		dataType: 'json',
		success: function(){
			console.log("Foto terhapus");
		},
		error: function(){
			console.log("Error");

		}
	});
});

}


//

	$(document).ready(function() {

		function show() {
			call('api/proposal_mahasiswa/details/' + seminar_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'mahasiswa/proposal';
					})
				} else {
					console.log(res.data)

					
					$('.tanggal_jam').html(res.data.tanggal + ' ' + res.data.jam);
					$('[name=tanggal]').val(res.data.tanggal);
					$('[name=jam]').val(res.data.jam);
					$('[name=ringkasan]').val(res.data.ringkasan);
					$('[name=proposal_mahasiswa_judul]').val(res.data.proposal_mahasiswa_judul);
                    
                    $('[name=dosen_id]').val(res.data.dosen1);
                    $('[name=dosen2_id]').val(res.data.dosen2);
					$('[name=dosen_penguji_id]').val(res.data.dosen3);

                    $('[name=jenis_skripsi]').val(res.data.jenis_skripsi);

					$('.file_3A2a').html(`<a href="` + base_url + `cdn/vendor/file_3A2/` + res.data.file_3A2 + `" target="_blank">` + res.data.file_3A2 + `</a>`);
					$('.file_3A2').html(('') ? `<a href="` + base_url + `cdn/vendor/file_3A2/` + '' + `">` + '' + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-file_3A2">');
					

					$('#dosen_penguji_display').val(res.data.dosen3);
					$('#dosen_penguji_id').val(res.data.dosen3);					

				}
			})
		}

		show()


		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			call('api/proposal_mahasiswa/edit3/' + seminar_id, $(this).serialize()).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Selesai')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Selesai')
				}
			})
		})


	})



function kirimData(nilai) {

    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>remove_foto/post",
        data: { token: nilai },
        success: function(response) {
        
		window.location.href = '<?php echo $previous_page;?>';


        }
    });
}	




</script>

<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>