<?php $this->app->extend('template/mahasiswa') ?>

<?php $this->app->setVar('title', 'Seminar Akhir') ?>

<?php $this->app->section() ?>


<link rel="stylesheet" href="<?= base_url() ?>assets/dropzone/bootstrap.min.css">
<link rel="stylesheet" href="<?= base_url() ?>assets/dropzone/dropzone.min.css">
<script src="<?= base_url() ?>assets/dropzone/dropzone.min.js"></script>
<script src="<?= base_url() ?>assets/dropzone/jquery-3.3.1.min.js"></script>


<div class="card">
    <div class="card-header">
        <div class="row">
            <div class="col">
                <div class="card-title">Seminar Akhir / Skripsi</div>
            </div>
            <div class="col text-right">
                <button class="btn btn-primary" type="button" data-toggle="modal" data-target="#tambah">
                    <i class="fa fa-plus"></i>
                    Tambah
                </button>
            </div>
        </div>
        <div class="card-tools mt-2">
            <span class="badge badge-success"><i class="fa fa-check"></i> Disetujui</span>
            <span class="badge badge-danger ml-3"><i class="fa fa-times"></i> Belum/Tidak Disetujui</span>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="data-skripsi">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Status</th>
                        <th>Judul Skripsi</th>
                        <th>Dosen Pembimbing</th>
                        <th>Dosen Penguji</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="edit">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="edit">
                <div class="modal-header">
                    <div class="modal-title">Edit Proposal</div>
                </div>
                <div class="modal-body">
                    <input type="hidden" class="id">
                    <input type="hidden" name="mahasiswa_id" value="<?= $this->session->userdata('id') ?>">
                    <div class="form-group">
                        <label>Judul Skripsi</label>
                        <input type="text" class="form-control" name="judul_skripsi" placeholder="Masukkan Judul Skripsi">
                    </div>

    
                    <div class="form-group">
                        <label>Jadwal Skripsi</label>
                        <input name="jadwal_skripsi" type="text" class="form-control dateTime" placeholder="Pilih Jadwal Skripsi" readonly>
                    </div>
					

					
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>

        </div>
    </div>
</div>
<div class="modal fade" id="tambah">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="tambah">
                <div class="modal-header">
                    <div class="modal-title">Tambah Skripsi</div>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="mahasiswa_id" value="<?= $this->session->userdata('id'); ?>">

                    <div class="form-group">
                        <label>Proposal</label>
                        <select name="proposal_mahasiswa_id" class="form-control">
                            <option value="">- Pilih Proposal -</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Judul Skripsi</label>
                        <input type="text" class="form-control" name="judul_skripsi" placeholder="Masukkan Judul Skripsi">
                    </div>
                    <div class="form-group">
                        <label>Tempat</label>
                        <textarea name="tempat" rows="3" class="form-control" placeholder="Masukkan Tempat Seminar"></textarea>
                    </div>    
 
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Tanggal</label>
                                <input type="date" name="tanggal" class="form-control">
                            </div>
                        </div>
                        <div class="col-md">
                            <div class="form-group">
                                <label>Jam</label>
                                <input type="time" name="jam" class="form-control">
                            </div>
                        </div>
                    </div>                   
                    
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>

	<div class="card-body">
		<form action="" class="dropzone" id="dropzone">

		</form>
		<a href=""></a>
	</div>


        </div>
    </div>
</div>
<div class="modal fade" id="hapus">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="hapus">
                <div class="modal-header">
                    <div class="modal-title">Hapus Penelitian</div>
                </div>
                <div class="modal-body">
                    <input type="hidden" class="id">
                    <p>Anda yakin menghapus penelitian terpilih ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<link rel="stylesheet" href="<?= base_url() ?>cdn/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<script src="<?= base_url() ?>cdn/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>cdn/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script>


// start Dropzone

Dropzone.autoDiscover = false;

var foto_upload= new Dropzone(".dropzone",{
url: "<?= base_url() ?>upload-skripsi/post",    
maxFilesize: 2,
method:"post",
//acceptedFiles: ".jpeg,.jpg,.png,.gif,.pdf,.doc,.docx",
acceptedFiles: ".pdf",
paramName:"file",
dictInvalidFileType:"Type file ini tidak dizinkan",
dictDefaultMessage: "Sebelum Simpan, Letakkan dokumen di sini (atau klik) untuk mengambil/mengunggah",
addRemoveLinks:true,

success: function(file, response) {

    // Handle success, misalnya menyimpan data file ke database atau menampilkan thumbnail
    console.log("File berhasil diunggah:", file, response);

  },
  error: function(file, response) {
    // Handle error
    console.error("Gagal mengunggah file:", file, response);
  },


});

//Event ketika Memulai mengupload
foto_upload.on("sending",function(a,b,c){
	
	a.token=Math.random();
	c.append("token_foto",a.token); //Menmpersiapkan token untuk masing masing foto

});


//Event ketika foto dihapus
foto_upload.on("removedfile",function(a){
	var token=a.token;
	$.ajax({
		type:"post",
		data:{token:token},
        url: "<?= base_url() ?>remove-skripsi/post",
		cache:false,
		dataType: 'json',
		success: function(){
			console.log("Foto terhapus");
		},
		error: function(){
			console.log("Error");

		}
	});
});

// end Dropzone




    $(document).ready(function() {


        $.ajax({
            url: base_url + 'getData/proposal_mahasiswa',
            type: 'post',
            data: {
                mahasiswa_id: <?= $this->session->userdata('id') ?>
            },
            dataType: 'json',
            success: function(res) {
                proposal = `<option value="">- Pilih Proposal -</option>`;
                $.each(res, function(i, item) {
                    if (item.status == '1' && item.dosen_penguji_id > '0') {
                        proposal += `<option value="` + item.id + `">` + item.judul + `</option>`;
                    }
                })
                $('[name=proposal_mahasiswa_id]').html(proposal);
            }
        })

        call('api/mahasiswa/detail/<?= $this->session->userdata('id') ?>').done(function(req) {

        if (req.data.dosen.jenis_skripsi >= '2') {
            
            let inprea = document.getElementById("pilih-loa"); 
            inprea.disabled = false;
            let inprea1 = document.getElementById("edit-loa"); 
            inprea1.disabled = false; 
                
        }else{

            let inprea = document.getElementById("pilih-loa"); 
            inprea.disabled = true;
            let inprea1 = document.getElementById("edit-loa"); 
            inprea1.disabled = true;        

        }


        })

        call('api/dosen').done(function(res) {
            dosen = `<option value="">- Pilih Dosen -</option>`;
            if (res.data) {
                res.data.forEach(obj => {
                    dosen += `<option value="` + obj.id + `">` + obj.nama + `</option>`;
                })
            }
            $('[name=dosen_id]').html(dosen);
			$('[name=dosen2_id]').html(dosen);
            $('[name=dosen_penguji_id]').html(dosen);
        })

        show = () => {
            $('#data-skripsi').DataTable().destroy();
            $('#data-skripsi').DataTable({
                "deferRender": true,
                "ajax": {
                    "url": base_url + "api/skripsi",
                    "method": "POST",
                    "data": {
                        mahasiswa_id: "<?= $this->session->userdata('id') ?>"
                    },
                    "dataSrc": "data"
                },
                "columns": [{
                        data: null,
                        render: function(data, type, row, meta) {
                            return meta.row + meta.settings._iDisplayStart + 1;
                        }
                    },
                    {
                        data: null,
                        render: function(data) {
                            if (data.status == '1') {
                                status = '\
                            <span class="badge badge-success mr-2"><i class="fa fa-check"></i></span>';
                            } else {
                                status = '\
                            <span class="badge badge-danger"><i class="fa fa-times"></i></span>\
                            ';
                            }
                            return '\
                            <div class="text-center">' + status + '</div>\
                            ';
                        }
                    },
                    {
                        data: "judul_skripsi"
                    },
                    {
                        data: "nama_pembimbing"
                    },
                    {
                        data: "nama_penguji"
                    },
                    {
                        data: null,
                        render: function(data) {
                            return `
                        <div class="text-center">
                            <a href="` + base_url + `mahasiswa/skripsi/detail/` + data.id_skripsi + `" class="btn btn-sm btn-success">
                                <i class="fa fa-search"></i>
                            </a>
                            <button class="btn btn-danger btn-hapus btn-sm" type="button" data-toggle="modal" data-target="#hapus" data-id="` + data.id_skripsi + `">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                        `;



                        }
                    }
                ],
                "language": {
                    "zeroRecords": "data tidak tersedia"
                }
            });
        }

        show();

        $(document).on('submit', 'form#tambah', function(e) {
            e.preventDefault();
            call('api/skripsi/create', $(this).serialize()).done(function(res) {
                if (res.error == true) {
                    notif(res.message, 'error', true);
                } else {
                    notif(res.message, 'success');
                    $('form#tambah [name]').val('');
                    $('div#tambah').modal('hide');
                    show();
                }
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-file_skripsi]', function() {
            read('form#tambah [name=pilih-file_skripsi]', function(data) {
                $('form#tambah [name=file_skripsi]').val(data.result);
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-persetujuan]', function() {
            read('form#tambah [name=pilih-persetujuan]', function(data) {
                $('form#tambah [name=persetujuan]').val(data.result);
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-bukti_konsultasi]', function() {
            read('form#tambah [name=pilih-bukti_konsultasi]', function(data) {
                $('form#tambah [name=bukti_konsultasi]').val(data.result);
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-sk_tim]', function() {
            read('form#tambah [name=pilih-sk_tim]', function(data) {
                $('form#tambah [name=sk_tim]').val(data.result);
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-revisi]', function() {
            read('form#tambah [name=pilih-revisi]', function(data) {
                $('form#tambah [name=revisi]').val(data.result);
            })
        })		

        $(document).on('change', 'form#tambah [name=pilih-btp]', function() {
            read('form#tambah [name=pilih-btp]', function(data) {
                $('form#tambah [name=btp]').val(data.result);
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-htp]', function() {
            read('form#tambah [name=pilih-htp]', function(data) {
                $('form#tambah [name=htp]').val(data.result);
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-bsnp]', function() {
            read('form#tambah [name=pilih-bsnp]', function(data) {
                $('form#tambah [name=bsnp]').val(data.result);
            })
        })

        $(document).on('change', 'form#tambah [name=pilih-loa]', function() {
            read('form#tambah [name=pilih-loa]', function(data) {
                $('form#tambah [name=loa]').val(data.result);
            })
        })
		
		
		

        $(document).on('change', 'form#edit [name=pilih-file_skripsi]', function() {
            read('form#edit [name=pilih-file_skripsi]', function(data) {
                $('form#edit [name=file_skripsi]').val(data.result);
            })
        })

        $(document).on('change', 'form#edit [name=pilih-sk_tim]', function() {
            read('form#edit [name=pilih-sk_tim]', function(data) {
                $('form#edit [name=sk_tim]').val(data.result);
            })
        })

        $(document).on('change', 'form#edit [name=pilih-persetujuan]', function() {
            read('form#edit [name=pilih-persetujuan]', function(data) {
                $('form#edit [name=persetujuan]').val(data.result);
            })
        })

        $(document).on('change', 'form#edit [name=pilih-bukti_konsultasi]', function() {
            read('form#edit [name=pilih-bukti_konsultasi]', function(data) {
                $('form#edit [name=bukti_konsultasi]').val(data.result);
            })
        })


        $(document).on('change', 'form#edit [name=pilih-revisi]', function() {
            read('form#edit [name=pilih-revisi]', function(data) {
                $('form#edit [name=revisi]').val(data.result);
            })
        })

        $(document).on('change', 'form#edit [name=pilih-btp]', function() {
            read('form#edit [name=pilih-btp]', function(data) {
                $('form#edit [name=btp]').val(data.result);
            })
        })		

        $(document).on('change', 'form#edit [name=pilih-htp]', function() {
            read('form#edit [name=pilih-htp]', function(data) {
                $('form#edit [name=htp]').val(data.result);
            })
        })	

        $(document).on('change', 'form#edit [name=pilih-bsnp]', function() {
            read('form#edit [name=pilih-bsnp]', function(data) {
                $('form#edit [name=bsnp]').val(data.result);
            })
        })

        $(document).on('change', 'form#edit [name=pilih-loa]', function() {
            read('form#edit [name=pilih-loa]', function(data) {
                $('form#edit [name=loa]').val(data.result);
            })
        })		
		
		

        $(document).on('click', 'button.btn-hapus', function() {
            $('form#hapus .id').val($(this).data('id'));
        })

        $(document).on('submit', 'form#hapus', function(e) {
            e.preventDefault();
            const id = $('form#hapus .id').val();
            call('api/skripsi/destroy/' + id).done(function(res) {
                if (res.error == true) {
                    notif(res.message, 'error', true);
                } else {
                    notif(res.message, 'success');
                    $('div#hapus').modal('hide');
                    show();
                }
            })
        })

    })

    $(document).on('click', 'button.btn-edit', function() {
        $('form#edit .id').val($(this).data('id'));
     
        $('form#edit [name=mahasiswa_id]').val($(this).data('mahasiswa_id'));
        $('form#edit [name=judul_skripsi]').val($(this).data('judul_skripsi'));
        $('form#edit [name=jadwal_skripsi]').val($(this).data('jadwal_skripsi'));
     
        $('form#edit [name=def_file_skripsi]').val($(this).data('file_skripsi'));
		$('form#edit [name=file_skripsi]').val('');
        $('form#edit [name=def_sk_tim]').val($(this).data('sk_tim'));
		$('form#edit [name=sk_tim]').val('');
        $('form#edit [name=def_persetujuan]').val($(this).data('persetujuan'));
        $('form#edit [name=persetujuan]').val('');		
        $('form#edit [name=def_bukti_konsultasi]').val($(this).data('bukti_konsultasi'));
		$('form#edit [name=bukti_konsultasi]').val('');
		$('form#edit [name=def_revisi]').val($(this).data('revisi'));
		$('form#edit [name=revisi]').val('');
		$('form#edit [name=def_btp]').val($(this).data('btp'));
		$('form#edit [name=btp]').val('');
		$('form#edit [name=def_htp]').val($(this).data('htp'));
		$('form#edit [name=htp]').val('');
		$('form#edit [name=def_bsnp]').val($(this).data('bsnp'));
		$('form#edit [name=bsnp]').val('');
		$('form#edit [name=def_loa]').val($(this).data('loa'));
		$('form#edit [name=loa]').val('');
    })

    $(document).on('submit', 'form#edit', function(e) {
        e.preventDefault();
        var id = $('form#edit .id').val();
        call('api/skripsi/update/' + id, $(this).serialize()).done(function(req) {
            if (req.error == true) {
                notif(req.message, 'error', true);
            } else {
                notif(req.message, 'success');
                $('form#edit [name]').val('');
                $('div#edit').modal('hide');
                show();
            }
        })
    })
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>